/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.ProfileHMMAlgorithms;
import weka.classifiers.sequence.core.SpecialAlphabet;

public class DynamicProgAlgorithms
extends ProfileHMMAlgorithms {
    private static final long serialVersionUID = -3315055075359274012L;
    protected double[][] deleteMatrix;
    protected double[][] insertMatrix;
    protected double[][] matchMatrix;
    protected double score;
    protected String sequence;

    public DynamicProgAlgorithms(ProfileHMM net, String sequence) {
        super(net);
        EmissionState end = net.getEndState();
        SpecialAlphabet endAlphabet = (SpecialAlphabet)end.getAlphabet();
        this.sequence = sequence + endAlphabet.toString();
    }

    private double getProbability(EmissionState actual, int sequencePosition) throws IllegalSymbolException {
        return actual.getEmissionProbability("" + this.sequence.charAt(sequencePosition));
    }

    protected double calculateLogEmissionProbability(EmissionState actual, int sequencePosition) throws IllegalSymbolException {
        double prob = this.getProbability(actual, sequencePosition);
        if (!this.logForTransitionsEmissions) {
            if (this.useNullModel) {
                prob = actual.equals(this.net.getEndState()) ? 1.0 : (prob /= this.net.getNullModel().getNullModelEmissionProbability("" + this.sequence.charAt(sequencePosition)));
            }
            return Math.log(prob);
        }
        if (this.useNullModel) {
            prob = actual.equals(this.net.getEndState()) ? 0.0 : (prob -= this.net.getNullModel().getNullModelEmissionProbability("" + this.sequence.charAt(sequencePosition)));
        }
        return prob;
    }

    public double getDeleteMatrixPos(int stateNumber, int sequencePosition) {
        return this.deleteMatrix[stateNumber][sequencePosition];
    }

    public double getInsertMatrixPos(int stateNumber, int sequencePosition) {
        return this.insertMatrix[stateNumber][sequencePosition];
    }

    public double getMatchMatrixPos(int stateNumber, int sequencePosition) {
        return this.matchMatrix[stateNumber][sequencePosition];
    }

    public double getScore() {
        return this.score;
    }
}

