/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.util.Vector;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.Distribution;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.State;

public class EmissionState
extends State {
    private static final long serialVersionUID = -5075868906426660915L;
    private Alphabet emissionAlphabet;
    private Distribution dist;

    public EmissionState(String name, int id, Alphabet alpha, Distribution dist) {
        this.name = name;
        this.id = id;
        this.incoming = new Vector();
        this.outgoing = new Vector();
        this.emissionAlphabet = alpha;
        this.dist = dist;
    }

    public double getEmissionProbability(String symbol) throws IllegalSymbolException {
        return this.dist.getProb(symbol);
    }

    public Alphabet getAlphabet() {
        return this.emissionAlphabet;
    }

    public void setDistribution(Distribution dist) {
        this.dist = dist;
    }

    public String outputEmissionInformation() {
        StringBuffer output = new StringBuffer();
        output.append(this.getFullNameId() + " emits: ");
        output.append(this.dist.toString() + "\n");
        return output.toString();
    }

    public Distribution getDistribution() {
        return this.dist;
    }
}

