/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.State;
import weka.classifiers.sequence.core.Transition;

public class ProfileHMMAlgorithms
implements Serializable {
    private static final long serialVersionUID = -7404699439770901266L;
    protected ProfileHMM net;
    protected boolean useNullModel;
    protected boolean logForTransitionsEmissions;

    public static double logplus(double plog, double qlog) {
        double diff;
        double max;
        if (plog > qlog) {
            if (qlog == Double.NEGATIVE_INFINITY) {
                return plog;
            }
            max = plog;
            diff = qlog - plog;
        } else {
            if (plog == Double.NEGATIVE_INFINITY) {
                return qlog;
            }
            max = qlog;
            diff = plog - qlog;
        }
        return max + (diff < -37.0 ? 0.0 : Math.log(1.0 + Math.exp(diff)));
    }

    public double getIncomingTransitionProbTo(State start, State end) throws InvalidStructureException {
        if (this.logForTransitionsEmissions) {
            return start.getIncomingTransitionProbTo(end);
        }
        return Math.log(start.getIncomingTransitionProbTo(end));
    }

    public double getIncomingTransitionProbFrom(State end, State start) throws InvalidStructureException {
        if (this.logForTransitionsEmissions) {
            return end.getIncomingTransitionProbFrom(start);
        }
        return Math.log(end.getIncomingTransitionProbFrom(start));
    }

    public double getTransitionProbability(Transition transition) {
        if (this.logForTransitionsEmissions) {
            return transition.getProbability();
        }
        return Math.log(transition.getProbability());
    }

    public void setTransitionProbability(Transition transition, double probabilityInLogForm) {
        if (this.logForTransitionsEmissions) {
            transition.setProbability(probabilityInLogForm);
        } else {
            transition.setProbability(Math.exp(probabilityInLogForm));
        }
    }

    public static double logsum(double alog, double blog) {
        if (alog == Double.NEGATIVE_INFINITY || blog == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return alog + blog;
    }

    public ProfileHMMAlgorithms(ProfileHMM net) {
        this.net = net;
        this.useNullModel = net.getNullModel() != null;
        this.logForTransitionsEmissions = net.isUseLogSpace();
    }
}

