/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.util.Random;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.StaticDistribution;
import weka.core.Utils;

public class RandomDistribution
extends StaticDistribution {
    private static final long serialVersionUID = 2030604510757664934L;
    private int seed;

    public RandomDistribution(Alphabet alpha, boolean useLogSpace) {
        super(alpha, useLogSpace);
        this.seed = 0;
        this.generateRandomDistribution(useLogSpace);
    }

    public RandomDistribution(Alphabet alpha, boolean useLogSpace, int seed) {
        super(alpha, useLogSpace);
        this.seed = seed;
        this.generateRandomDistribution(useLogSpace);
    }

    private void generateRandomDistribution(boolean useLogSpace) {
        int i;
        Random rand = new Random(this.seed);
        for (i = 0; i < this.probs.length; ++i) {
            this.probs[i] = rand.nextDouble();
        }
        Utils.normalize((double[])this.probs);
        if (useLogSpace) {
            for (i = 0; i < this.probs.length; ++i) {
                if (this.probs[i] != 0.0) {
                    if (this.probs[i] == 1.0) {
                        this.probs[i] = 0.0;
                        continue;
                    }
                    this.probs[i] = Math.log(this.probs[i]);
                    continue;
                }
                this.probs[i] = Double.NEGATIVE_INFINITY;
            }
        }
    }

    public int getSeed() {
        return this.seed;
    }
}

