/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.BackwardAlgorithm;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.ForwardAlgorithm;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.NumericStabilityException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.ProfileHMMAlgorithms;

public class SufficientEmissionStatistics
extends ProfileHMMAlgorithms {
    private static final long serialVersionUID = 360896614085679006L;
    private boolean includeInserts;
    protected double[][] emissionCountMatrix;
    private double[] sufficientEmissionStats;

    public SufficientEmissionStatistics(ProfileHMM net, boolean includeInserts) {
        super(net);
        this.includeInserts = includeInserts;
        this.emissionCountMatrix = includeInserts ? new double[2 * this.net.getNumberMatchStates() - 1][this.net.getAlphabet().alphabetSize()] : new double[this.net.getNumberMatchStates()][this.net.getAlphabet().alphabetSize()];
        for (int i = 0; i < this.emissionCountMatrix.length; ++i) {
            for (int j = 0; j < this.emissionCountMatrix[0].length; ++j) {
                this.emissionCountMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        this.sufficientEmissionStats = new double[this.net.getNumberMatchStates() * this.net.getAlphabet().alphabetSize()];
    }

    public double[] getStats(String sequence) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, NumericStabilityException {
        int i;
        ForwardAlgorithm fwd = new ForwardAlgorithm(this.net, sequence);
        fwd.calculateForward();
        double probability = fwd.getScore();
        BackwardAlgorithm bwd = new BackwardAlgorithm(this.net, sequence);
        bwd.calculateBackward();
        this.emissionCountMatrix = new double[this.net.getNumberMatchStates()][this.net.getAlphabet().alphabetSize()];
        for (i = 0; i < this.emissionCountMatrix.length; ++i) {
            for (int j = 0; j < this.emissionCountMatrix[0].length; ++j) {
                this.emissionCountMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        for (i = 0; i < sequence.length(); ++i) {
            this.calculateEmissionFrequency(sequence, i, fwd, bwd, probability);
        }
        double sum = Double.NEGATIVE_INFINITY;
        for (int stateIndex = 0; stateIndex < this.emissionCountMatrix.length; ++stateIndex) {
            double[] allEmissions = this.emissionCountMatrix[stateIndex];
            for (int i2 = 0; i2 < allEmissions.length; ++i2) {
                sum = SufficientEmissionStatistics.logplus(sum, allEmissions[i2]);
            }
            if (sum != Double.NEGATIVE_INFINITY) continue;
            throw new NumericStabilityException("Can't normalize array. Sum is negative infinity.");
        }
        sum *= -1.0;
        int numberSymbols = this.net.getAlphabet().alphabetSize();
        for (int column = 0; column < this.emissionCountMatrix.length; ++column) {
            for (int symbol = 0; symbol < numberSymbols; ++symbol) {
                EmissionState actual = this.net.getMatchState(column);
                double probSymbolState = actual.getEmissionProbability(this.net.getAlphabet().getSymbolAtIndex(symbol));
                this.emissionCountMatrix[column][symbol] = this.emissionCountMatrix[column][symbol] - probSymbolState;
            }
        }
        int index = 0;
        for (int column = 0; column < this.emissionCountMatrix.length; ++column) {
            for (int symbol = 0; symbol < numberSymbols; ++symbol) {
                this.sufficientEmissionStats[index] = Math.exp(SufficientEmissionStatistics.logplus(this.emissionCountMatrix[column][symbol], sum));
                ++index;
            }
        }
        return this.sufficientEmissionStats;
    }

    private void calculateEmissionFrequency(String sequence, int sequencePosition, ForwardAlgorithm fwd, BackwardAlgorithm bwd, double probabilityForSequence) throws IllegalSymbolException {
        int columns = this.net.getNumberMatchStates();
        char charAtSeq = sequence.charAt(sequencePosition);
        Alphabet alphabet = this.net.getAlphabet();
        int alphabetIndex = alphabet.indexOfAlphabetSymbol(charAtSeq + "");
        for (int k = 0; k < columns; ++k) {
            double forwardContribution = fwd.getMatchMatrixPos(k, sequencePosition);
            double backwardContribution = bwd.getMatchMatrixPos(k, sequencePosition);
            this.emissionCountMatrix[k][alphabetIndex] = SufficientEmissionStatistics.logplus(this.emissionCountMatrix[k][alphabetIndex], forwardContribution + backwardContribution - probabilityForSequence);
        }
    }
}

