/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class LogPathScores2Probabilities
extends Filter
implements SupervisedFilter {
    private static final long serialVersionUID = 7048394782746762929L;

    public String getRevision() {
        return "1.0";
    }

    public String globalInfo() {
        return "A batch filter that converts arff files created in Mode 2 or Mode 3 (not Mode 23) to probablities for binary PHMMs.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(new Instances(instanceInfo, 0));
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        Instances inst = this.getInputFormat();
        int numberLogAttributes = inst.numAttributes() - 1;
        for (int i = 0; i < inst.numInstances(); ++i) {
            int k;
            Instance instance = inst.instance(i);
            double[] probs = new double[numberLogAttributes];
            for (k = 0; k < numberLogAttributes; ++k) {
                probs[k] = instance.value(k);
            }
            probs = Utils.logs2probs((double[])probs);
            Utils.normalize((double[])probs);
            for (k = 0; k < numberLogAttributes; ++k) {
                instance.setValue(k, probs[k]);
            }
            this.push(instance);
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] argv) {
        LogPathScores2Probabilities.runFilter((Filter)new LogPathScores2Probabilities(), (String[])argv);
    }
}

