/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.env.Environment;
import java.io.File;
import java.net.MalformedURLException;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailHelper {
    public static final String FILENAME = "Email.props";
    public static final String ENABLED = "Enabled";
    public static final String SMTP_SERVER = "SmtpServer";
    public static final String SMTP_PORT = "SmtpPort";
    public static final String SMTP_REQUIRES_AUTHENTICATION = "SmtpRequiresAuthentication";
    public static final String SMTP_START_TLS = "SmtpStartTls";
    public static final String SMTP_USER = "SmtpUser";
    public static final String SMTP_PASSWORD = "SmtpPassword";
    public static final String DEFAULT_ADDRESS_FROM = "DefaultAddressFrom";
    public static final String DEFAULT_SIGNATURE = "DefaultSignature";
    public static final String KEY_SMTPHOST = "mail.smtp.host";
    public static final String KEY_SMTPPORT = "mail.smtp.port";
    public static final String KEY_STARTTLS = "mail.smtp.starttls.enable";
    public static final String KEY_SMTPAUTH = "mail.smtp.auth";
    public static final String SIGNATURE_SEPARATOR = "--";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("email");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return EmailHelper.writeProperties(EmailHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("email", props);
        m_Properties = null;
        return result;
    }

    public static boolean isEnabled() {
        return EmailHelper.getProperties().getBoolean(ENABLED, Boolean.valueOf(false));
    }

    public static String getSmtpServer() {
        return EmailHelper.getProperties().getString(SMTP_SERVER, "somehost");
    }

    public static int getSmtpPort() {
        return EmailHelper.getProperties().getInteger(SMTP_PORT, Integer.valueOf(25));
    }

    public static boolean getSmtpStartTLS() {
        return EmailHelper.getProperties().getBoolean(SMTP_START_TLS, Boolean.valueOf(false));
    }

    public static boolean getSmtpRequiresAuthentication() {
        return EmailHelper.getProperties().getBoolean(SMTP_REQUIRES_AUTHENTICATION, Boolean.valueOf(false));
    }

    public static String getSmtpUser() {
        return EmailHelper.getProperties().getString(SMTP_USER, "john.doe");
    }

    public static BasePassword getSmtpPassword() {
        return new BasePassword(EmailHelper.getProperties().getString(SMTP_PASSWORD, "password"));
    }

    public static String getDefaultFromAddress() {
        return EmailHelper.getProperties().getString(DEFAULT_ADDRESS_FROM, "john.doe@nowhere.org");
    }

    public static String getDefaultSignature() {
        return EmailHelper.getProperties().getString(DEFAULT_SIGNATURE, "");
    }

    public static java.util.Properties initializeSmtpServer() {
        java.util.Properties result = System.getProperties();
        result.setProperty(KEY_SMTPHOST, EmailHelper.getSmtpServer());
        result.setProperty(KEY_SMTPPORT, "" + EmailHelper.getSmtpPort());
        result.setProperty(KEY_STARTTLS, "" + EmailHelper.getSmtpStartTLS());
        result.setProperty(KEY_SMTPAUTH, "" + EmailHelper.getSmtpRequiresAuthentication());
        return result;
    }

    public static Session initializeSmtpSession(java.util.Properties props) {
        Session result = EmailHelper.getSmtpRequiresAuthentication() ? Session.getInstance((java.util.Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailHelper.getSmtpUser(), EmailHelper.getSmtpPassword().getValue());
            }
        }) : Session.getInstance((java.util.Properties)props);
        return result;
    }

    public static MimeMessage newMessage(Session session, String toAddress, String subject) throws AddressException, MessagingException {
        return EmailHelper.newMessage(session, new String[]{toAddress}, subject);
    }

    public static MimeMessage newMessage(Session session, String[] toAddress, String subject) throws AddressException, MessagingException {
        return EmailHelper.newMessage(session, toAddress, null, null, subject);
    }

    public static MimeMessage newMessage(Session session, String[] toAddress, String[] ccAddress, String[] bccAddress, String subject) throws AddressException, MessagingException {
        int i;
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(EmailHelper.getDefaultFromAddress()));
        boolean noRecipient = true;
        if (toAddress != null) {
            noRecipient = toAddress.length == 0;
            for (i = 0; i < toAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress[i]));
            }
        }
        if (ccAddress != null) {
            noRecipient = ccAddress.length == 0;
            for (i = 0; i < ccAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccAddress[i]));
            }
        }
        if (bccAddress != null) {
            noRecipient = bccAddress.length == 0;
            for (i = 0; i < bccAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccAddress[i]));
            }
        }
        if (noRecipient) {
            throw new MessagingException("No recipients specified!");
        }
        message.setSubject(subject);
        return message;
    }

    public static boolean sendMail(String toAddress, String subject, String body) throws AddressException, MessagingException, MalformedURLException {
        return EmailHelper.sendMail(toAddress, subject, body, new File[0]);
    }

    public static boolean sendMail(String[] toAddress, String subject, String body) throws AddressException, MessagingException, MalformedURLException {
        return EmailHelper.sendMail(toAddress, subject, body, new File[0]);
    }

    public static boolean sendMail(String toAddress, String subject, String body, File[] attachments) throws AddressException, MessagingException, MalformedURLException {
        return EmailHelper.sendMail(new String[]{toAddress}, subject, body, attachments);
    }

    public static boolean sendMail(String[] toAddress, String subject, String body, File[] attachments) throws AddressException, MessagingException, MalformedURLException {
        return EmailHelper.sendMail(toAddress, null, null, subject, body, attachments);
    }

    public static boolean sendMail(String[] toAddress, String[] ccAddress, String[] bccAddress, String subject, String body, File[] attachments) throws AddressException, MessagingException, MalformedURLException {
        java.util.Properties props = EmailHelper.initializeSmtpServer();
        Session session = EmailHelper.initializeSmtpSession(props);
        MimeMessage message = EmailHelper.newMessage(session, toAddress, ccAddress, bccAddress, subject);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body);
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (int i = 0; i < attachments.length; ++i) {
            messageBodyPart = new MimeBodyPart();
            messageBodyPart.setDataHandler(new DataHandler(attachments[i].toURI().toURL()));
            messageBodyPart.setFileName(attachments[i].getName());
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        Transport.send((Message)message);
        return true;
    }

    public static String combine(String body, String signature) {
        if (signature == null || signature.trim().length() == 0) {
            return body;
        }
        return body + "\n" + SIGNATURE_SEPARATOR + "\n" + signature;
    }
}

