/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractSpreadSheetWriter;
import adams.core.io.SpreadSheet;
import java.io.OutputStream;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ODFSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -3549185519778801930L;
    public static String FILE_EXTENSION = ".ods";

    public String globalInfo() {
        return "Writes ODF (Open Document Format) spreadsheet files.";
    }

    public String getFormatDescription() {
        return "OpenDocument format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ods"};
    }

    protected boolean getUseOutputStream() {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        boolean result = true;
        try {
            int i;
            DefaultTableModel model = new DefaultTableModel(content.getRowCount() + 1, content.getColumnCount());
            for (i = 0; i < content.getColumnCount(); ++i) {
                model.setValueAt(content.getHeaderRow().getCell(i).getContent(), 0, i);
            }
            for (int n = 0; n < content.getRowCount(); ++n) {
                SpreadSheet.Row row = content.getRow(n);
                for (i = 0; i < content.getColumnCount(); ++i) {
                    SpreadSheet.Cell cell = row.getCell(i);
                    if (cell.isMissing()) {
                        model.setValueAt(this.m_MissingValue, n + 1, i);
                        continue;
                    }
                    model.setValueAt(cell.getContent(), n + 1, i);
                }
            }
            org.jopendocument.dom.spreadsheet.SpreadSheet spreadsheet = org.jopendocument.dom.spreadsheet.SpreadSheet.createEmpty((TableModel)model);
            spreadsheet.getPackage().save(out);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }
}

