/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AttachmentTools {
    private static final Logger Log = LogTools.getLogger(FileTools.class);

    protected static String createAttachmentName(String masterName, String movedName, String attachName) {
        String prefix = StringTools.getCommonPrefix(masterName, attachName, true);
        int masterSuffixLength = masterName.length() - prefix.length();
        int attachSuffixLength = attachName.length() - prefix.length();
        String newName = movedName;
        newName = newName.substring(0, newName.length() - masterSuffixLength);
        newName = String.valueOf(newName) + attachName.substring(attachName.length() - attachSuffixLength);
        return newName;
    }

    public static List createAttachments(File master, File[] files, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return Collections.EMPTY_LIST;
        }
        String targetName = null;
        String targetBaseName = null;
        if (master != null) {
            targetName = master.getName().toLowerCase();
            targetBaseName = FileTools.getBaseName(targetName);
        }
        ArrayList<File> result = new ArrayList<File>();
        String[] tempExtensions = extensions.toLowerCase().split(";");
        int j = 0;
        while (j < files.length) {
            File checkFile = files[j];
            String tempName = checkFile.getName().toLowerCase();
            if (!tempName.equals(targetName)) {
                String tempBaseName = FileTools.getBaseName(tempName);
                if (master == null || tempBaseName.equals(targetName) || tempBaseName.equals(targetBaseName)) {
                    int i = 0;
                    while (i < tempExtensions.length) {
                        if (tempName.endsWith(tempExtensions[i])) {
                            result.add(checkFile);
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        return result;
    }

    public static List createAttachments(File master, String extensions) {
        File tempFile;
        File tempDir;
        if (master.isDirectory()) {
            tempDir = master;
            tempFile = null;
        } else {
            tempDir = master.getParentFile();
            tempFile = master;
        }
        if (tempDir == null) {
            return null;
        }
        File[] files = tempDir.listFiles();
        return AttachmentTools.createAttachments(tempFile, files, extensions);
    }

    public static void deleteAttachments(List attachments) {
        for (Object attachment : attachments) {
            ILocator tempLocator;
            if (attachment instanceof File) {
                if (!((File)attachment).exists() || ((File)attachment).delete()) continue;
                Log.log(Level.WARNING, "deleting '" + attachment + "' failed");
                continue;
            }
            if (attachment instanceof ILocator) {
                if (!((ILocator)attachment).exists()) continue;
                try {
                    ((ILocator)attachment).delete();
                }
                catch (IOException e) {
                    Log.log(Level.WARNING, "deleting '" + attachment + "' failed");
                }
                continue;
            }
            if (!(attachment instanceof ILocatorSupport) || !(tempLocator = ((ILocatorSupport)attachment).getLocator()).exists()) continue;
            try {
                tempLocator.delete();
            }
            catch (IOException e) {
                Log.log(Level.WARNING, "deleting '" + tempLocator + "' failed");
            }
        }
    }

    public static File moveAttachment(File master, File attachment, File movedFile, boolean delete) {
        if (movedFile == null || attachment == null) {
            return null;
        }
        String masterName = master.getName();
        String movedName = movedFile.getName();
        File movedDir = movedFile.isDirectory() ? movedFile : movedFile.getParentFile();
        try {
            File movedAttachment = AttachmentTools.moveAttachment(masterName, attachment, movedName, movedDir, delete);
            return movedAttachment;
        }
        catch (Exception e) {
            Log.log(Level.WARNING, "failed to move attachment '" + attachment + "' attached to '" + master + "'");
            return attachment;
        }
    }

    protected static File moveAttachment(String masterName, Object attachment, String movedName, File dir, boolean delete) throws IOException {
        if (attachment instanceof FileLocator) {
            attachment = ((FileLocator)attachment).getFile();
        }
        if (attachment instanceof File) {
            File tempFile = (File)attachment;
            String tempName = tempFile.getName();
            String newName = AttachmentTools.createAttachmentName(masterName, movedName, tempName);
            File newAttachment = new File(dir, newName);
            if (delete) {
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "move '" + tempFile.getAbsolutePath() + "' to '" + newAttachment.getAbsolutePath() + "'");
                }
                FileTools.renameFile(tempFile, newAttachment);
            } else {
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "copy '" + tempFile.getAbsolutePath() + "' to '" + newAttachment.getAbsolutePath() + "'");
                }
                FileTools.copyFile(tempFile, newAttachment);
            }
            return newAttachment;
        }
        if (attachment instanceof ILocator) {
            ILocator tempLocator = (ILocator)attachment;
            String tempName = tempLocator.getTypedName();
            String newName = AttachmentTools.createAttachmentName(masterName, movedName, tempName);
            File newAttachment = new File(dir, newName);
            if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "create file '" + newAttachment.getAbsolutePath() + "'");
            }
            InputStream source = null;
            FileOutputStream destination = null;
            try {
                source = tempLocator.getInputStream();
                destination = new FileOutputStream(newAttachment);
                StreamTools.copyStream(source, destination);
            }
            catch (Throwable throwable) {
                StreamTools.close(source);
                StreamTools.close(destination);
                throw throwable;
            }
            StreamTools.close(source);
            StreamTools.close(destination);
            if (delete) {
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "delete locator '" + tempLocator.getFullName() + "'");
                }
                tempLocator.delete();
            }
            return newAttachment;
        }
        return null;
    }

    public static List moveAttachments(File master, List attachments, File movedFile, boolean delete) {
        if (master == null || movedFile == null || attachments == null || attachments.isEmpty()) {
            return attachments;
        }
        ArrayList<File> result = new ArrayList<File>();
        String masterName = master.getName();
        String movedName = movedFile.getName();
        File movedDir = movedFile.isDirectory() ? movedFile : movedFile.getParentFile();
        for (Object tempAttachment : attachments) {
            try {
                File movedAttachment = AttachmentTools.moveAttachment(masterName, tempAttachment, movedName, movedDir, delete);
                result.add(movedAttachment);
            }
            catch (Exception e) {
                result.add((File)tempAttachment);
                Log.log(Level.WARNING, "failed to move attachment '" + tempAttachment + "' attached to '" + master + "'");
            }
        }
        return result;
    }
}

