/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class SynchTools {
    private static byte[] bytes;

    public static void delSynchFile(File file) throws IOException {
        file.delete();
    }

    public static byte[] getBytes() {
        return bytes;
    }

    public static File getSynchFile() throws IOException {
        return File.createTempFile("synchfile", ".synch");
    }

    public static void setBytes(byte[] bytes) {
        SynchTools.bytes = bytes;
    }

    public static void setSynchFile(File file) throws IOException {
        SynchTools.setSynchFile(file, SynchTools.getBytes());
        bytes = null;
    }

    public static void setSynchFile(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        if (bytes != null) {
            os.write(bytes);
        }
        os.close();
    }

    public static void setSynchFile(File file, String value) throws IOException {
        FileWriter w = new FileWriter(file);
        w.write(value);
        w.close();
    }

    public static void waitSynchFile(File file, int timeout) throws IOException {
        long start = System.currentTimeMillis();
        long count = 0L;
        while (count < (long)timeout && !file.exists()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException("waiting for synch file '" + file.getPath() + "' interrupted");
            }
            count = System.currentTimeMillis() - start;
        }
        if (!file.exists()) {
            throw new IOException("timeout waiing for synch file '" + file.getPath() + "'");
        }
    }
}

