/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.FileFilter;

public class TempTools {
    private static File tempDir;
    private static File tempDirVM;
    private static FileTools.Lock lock;
    private static int fileCounter;
    private static int dirCounter;

    static {
        fileCounter = 0;
        dirCounter = 0;
        TempTools.cleanUp();
    }

    protected static void cleanUp() {
        File[] files = TempTools.getTempDir().listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(TempTools.class.getName());
            }
        });
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            TempTools.cleanUpTempDir(files[i]);
            ++i;
        }
    }

    protected static void cleanUpTempDir(File file) {
        FileTools.Lock tempLock = FileTools.lock(file);
        if (tempLock == null) {
            return;
        }
        tempLock.release();
        FileTools.deleteRecursivly(file);
    }

    public static synchronized File createTempDir(String prefix, String suffix) {
        String tempName = String.valueOf(prefix) + dirCounter++ + suffix;
        File tempFile = new File(TempTools.getTempDirVM(), tempName);
        tempFile.mkdirs();
        return tempFile;
    }

    protected static File createTempDirVM(File parent) {
        String name = TempTools.class.getName();
        File tempFile = new File(parent, name);
        int counter = 0;
        while ((tempFile = new File(parent, String.valueOf(name) + "_" + counter)).exists() || !tempFile.mkdirs() || (lock = FileTools.lock(tempFile)) == null) {
            ++counter;
        }
        return tempFile;
    }

    public static synchronized File createTempFile(String prefix, String suffix) {
        String tempName = String.valueOf(prefix) + fileCounter++ + suffix;
        File tempFile = new File(TempTools.getTempDirVM(), tempName);
        return tempFile;
    }

    public static File getTempDir() {
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        return tempDir;
    }

    public static File getTempDirVM() {
        if (tempDirVM == null) {
            tempDirVM = TempTools.createTempDirVM(TempTools.getTempDir());
        }
        return tempDirVM;
    }

    public static void setTempDir(File pTempDir) {
        tempDir = pTempDir;
    }
}

