/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;

public class ByteArrayLocator
extends CommonLocator
implements Serializable {
    protected byte[] content;
    protected int length;
    private String fullName;
    private String localName;
    private String type;

    public ByteArrayLocator(byte[] data, String pFullName) {
        if (data == null) {
            data = new byte[]{};
        }
        this.content = data;
        this.length = data.length;
        this.setFullName(pFullName);
    }

    public ByteArrayLocator(byte[] data, String pName, String pType) {
        if (data == null) {
            data = new byte[]{};
        }
        this.content = data;
        this.length = data.length;
        if (StringTools.isEmpty(pType)) {
            this.setFullName(pName);
        } else {
            this.setFullName(String.valueOf(pName) + "." + pType);
        }
    }

    public void delete() throws IOException {
    }

    public boolean exists() {
        return this.content != null;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.content, 0, result, 0, this.length);
        return result;
    }

    public ILocator getChild(String name) {
        return null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getFullName() {
        return this.fullName;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content, 0, this.length);
    }

    public long getLength() {
        return this.length;
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }

            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }
        };
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() {
        return new RandomAccessByteArray(this.content, this.length){

            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.content = this.data;
                ByteArrayLocator.this.length = this.length;
            }
        };
    }

    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String encoding) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) {
        return new ILocator[0];
    }

    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName, this.getType());
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }
}

