/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.ILocationProvider;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LocationAwareReader
extends FilterReader
implements ILocationProvider {
    private boolean open = true;
    private int line = 1;
    private int column = 1;
    private int position = 0;

    public LocationAwareReader(Reader in) {
        super(in);
    }

    public void close() throws IOException {
        this.open = false;
        this.in.close();
    }

    public void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int i = this.in.read();
            if (i != -1) {
                ++this.position;
                if (i == 10) {
                    ++this.line;
                    this.column = 1;
                } else {
                    ++this.column;
                }
            }
            return i;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int pos = off;
        int i = this.read();
        while (pos < off + len && i != -1) {
            cbuf[pos] = (char)i;
            ++pos;
            i = this.read();
        }
        if (i == -1 && pos == off) {
            return -1;
        }
        return pos - off;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IOException("parameter is negative");
        }
        long current = 0L;
        int ch = 0;
        while (current < n && ch != -1) {
            ch = this.read();
            ++current;
        }
        return current;
    }
}

