/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.AbstractClassifierTest;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.misc.InputMappedClassifier;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;
import weka.filters.unsupervised.attribute.SwapValues;

public class InputMappedClassifierTest
extends AbstractClassifierTest {
    public InputMappedClassifierTest(String name) {
        super(name);
    }

    @Override
    public Classifier getClassifier() {
        InputMappedClassifier toUse = new InputMappedClassifier();
        toUse.setClassifier((Classifier)new J48());
        toUse.setSuppressMappingReport(true);
        return toUse;
    }

    protected Instances reorderAtts(Instances data) throws Exception {
        Reorder r = new Reorder();
        String range = "last";
        for (int i = data.numAttributes() - 1; i > 0; --i) {
            range = range + "," + i;
        }
        r.setAttributeIndices(range);
        r.setInputFormat(data);
        data = Filter.useFilter((Instances)data, (Filter)r);
        return data;
    }

    protected Instances swapValues(int attIndex, Instances data) throws Exception {
        SwapValues s = new SwapValues();
        s.setAttributeIndex("" + attIndex);
        s.setFirstValueIndex("first");
        s.setSecondValueIndex("last");
        s.setInputFormat(data);
        data = Filter.useFilter((Instances)data, (Filter)s);
        return data;
    }

    protected Instances generateData(boolean nomClass, int numClasses, int numNominal, int numNumeric) throws Exception {
        TestInstances generator = new TestInstances();
        if (nomClass) {
            generator.setClassType(1);
            generator.setNumClasses(numClasses);
        } else {
            generator.setClassType(0);
        }
        generator.setNumNominal(numNominal);
        generator.setNumNumeric(numNumeric);
        generator.setNumDate(0);
        generator.setNumString(0);
        generator.setNumRelational(0);
        generator.setNumInstances(100);
        generator.setClassIndex(-1);
        Instances data = generator.generate();
        return data;
    }

    protected void performTest(boolean nomClass, int numClassesTrain, int numTrainAtts, boolean reorderAtts, boolean reorderNomLabels, boolean reorderClassLabels) {
        Instances train = null;
        Instances test = null;
        try {
            train = this.generateData(nomClass, numClassesTrain, numTrainAtts, 3);
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Generating training data failed: " + ex));
        }
        test = new Instances(train);
        if (reorderNomLabels) {
            try {
                test = this.swapValues(1, test);
            }
            catch (Exception ex) {
                InputMappedClassifierTest.fail((String)("Reordering nominal labels failed: " + ex));
            }
        }
        if (reorderClassLabels && nomClass) {
            try {
                test = this.swapValues(7, test);
            }
            catch (Exception ex) {
                InputMappedClassifierTest.fail((String)("Reordering class labels failed: " + ex));
            }
        }
        if (reorderAtts) {
            try {
                test = this.reorderAtts(test);
            }
            catch (Exception ex) {
                InputMappedClassifierTest.fail((String)("Reordering test data failed: " + ex));
            }
        }
        InputMappedClassifier toUse = null;
        try {
            toUse = this.trainClassifier(train, nomClass);
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Training classifier failed: " + ex));
        }
        double[] resultsOnTrainingStructure = null;
        try {
            resultsOnTrainingStructure = this.testClassifier(train, toUse);
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Testing classifier on training data failed: " + ex));
        }
        double[] resultsOnTestStructure = null;
        try {
            resultsOnTestStructure = this.testClassifier(test, toUse);
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Testing classifier on test data failed: " + ex));
        }
        try {
            for (int i = 0; i < resultsOnTrainingStructure.length; ++i) {
                if (resultsOnTrainingStructure[i] == resultsOnTestStructure[i]) continue;
                throw new Exception("Result #" + (i + 1) + " differs!");
            }
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Comparing results failed " + ex));
        }
    }

    public void testNominaClass() {
        this.performTest(true, 4, 3, false, false, false);
    }

    public void testNominaClassReorderedAtts() {
        this.performTest(true, 4, 3, true, false, false);
    }

    public void testNominalClassSwapNominalValues() {
        this.performTest(true, 4, 3, false, true, false);
    }

    public void testNominalClassSwapNominalValuesReorderAtts() {
        this.performTest(true, 4, 3, true, true, false);
    }

    public void testNominalClassSwapClassValues() {
        this.performTest(true, 4, 3, false, false, true);
    }

    public void testNominalClassSwapNominalValuesSwapClassValues() {
        this.performTest(true, 4, 3, false, true, true);
    }

    public void testNominalClassSwapNominalValuesSwapClassValuesReorderAtts() {
        this.performTest(true, 4, 3, true, true, true);
    }

    public void testNumericClass() {
        this.performTest(false, 4, 3, false, false, false);
    }

    public void testNumericClassReorderedAtts() {
        this.performTest(false, 4, 3, true, false, false);
    }

    public void testNumericClassSwapNominalValues() {
        this.performTest(false, 4, 3, false, true, false);
    }

    public void testNumericClassSwapNominalValuesReorderAtts() {
        this.performTest(false, 4, 3, true, true, false);
    }

    protected InputMappedClassifier trainClassifier(Instances data, boolean nominalClass) {
        InputMappedClassifier toUse = new InputMappedClassifier();
        if (nominalClass) {
            toUse.setClassifier((Classifier)new J48());
        } else {
            toUse.setClassifier((Classifier)new LinearRegression());
        }
        toUse.setSuppressMappingReport(true);
        try {
            toUse.buildClassifier(data);
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Training InputMappedClassifier failed: " + ex));
            return null;
        }
        return toUse;
    }

    protected double[] testClassifier(Instances test, InputMappedClassifier classifier) {
        double[] result = new double[test.numInstances()];
        try {
            for (int i = 0; i < test.numInstances(); ++i) {
                result[i] = classifier.classifyInstance(test.instance(i));
            }
        }
        catch (Exception ex) {
            InputMappedClassifierTest.fail((String)("Testing InputMappedClassifier failed: " + ex));
            return null;
        }
        return result;
    }

    public static Test suite() {
        return new TestSuite(InputMappedClassifierTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)InputMappedClassifierTest.suite());
    }
}

