/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AlgVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TestInstances;

public class AlgVectorTest
extends TestCase {
    protected Random m_Random;

    public AlgVectorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Random = new Random(1L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_Random = null;
    }

    protected Instances generateData(int nominal, int numeric, int rows) {
        Instances result;
        TestInstances test = new TestInstances();
        test.setClassIndex(-2);
        test.setNumNominal(nominal);
        test.setNumNumeric(numeric);
        test.setNumInstances(rows);
        try {
            result = test.generate();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public void testLengthConstructor() {
        int len = 22;
        AlgVector v = new AlgVector(len);
        AlgVectorTest.assertEquals((String)"Length differs", (int)len, (int)v.numElements());
    }

    public void testArrayConstructor() {
        double[] data = new double[]{2.3, 1.2, 5.0};
        AlgVector v = new AlgVector(data);
        AlgVectorTest.assertEquals((String)"Length differs", (int)data.length, (int)v.numElements());
        for (int i = 0; i < data.length; ++i) {
            AlgVectorTest.assertEquals((String)(i + 1 + ". value differs"), (Object)data[i], (Object)v.getElement(i));
        }
    }

    protected void runTestOnData(Instances data) {
        int n;
        int numeric = 0;
        for (n = 0; n < data.numAttributes(); ++n) {
            if (!data.attribute(n).isNumeric()) continue;
            ++numeric;
        }
        for (n = 0; n < data.numInstances(); ++n) {
            try {
                AlgVector v = new AlgVector(data.instance(n));
                AlgVectorTest.assertEquals((String)(n + 1 + ": length differs"), (int)numeric, (int)v.numElements());
                int index = 0;
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (!data.attribute(i).isNumeric()) continue;
                    AlgVectorTest.assertEquals((String)(n + 1 + "/" + (i + 1) + ": value differs"), (Object)data.instance(n).value(i), (Object)v.getElement(index));
                    ++index;
                }
                Instance inst = v.getAsInstance(data, new Random(1L));
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (!data.attribute(i).isNumeric()) continue;
                    AlgVectorTest.assertEquals((String)(n + 1 + "/" + (i + 1) + ": returned value differs"), (Object)data.instance(n).value(i), (Object)inst.value(i));
                }
                continue;
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) continue;
                AlgVectorTest.fail((String)e.toString());
            }
        }
    }

    public void testNumericInstances() {
        this.runTestOnData(this.generateData(0, 5, 5));
    }

    public void testNominalInstances() {
        this.runTestOnData(this.generateData(5, 0, 5));
    }

    public void testMixedInstances() {
        this.runTestOnData(this.generateData(5, 5, 5));
    }

    public static Test suite() {
        return new TestSuite(AlgVectorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AlgVectorTest.suite());
    }
}

