/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.test.Regression;

public abstract class AbstractNearestNeighbourSearchTest
extends TestCase {
    protected NearestNeighbourSearch m_NearestNeighbourSearch;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;
    protected Instances m_Instances;
    protected int m_NumNeighbors;
    protected Random m_Random;

    public AbstractNearestNeighbourSearchTest(String name) {
        super(name);
    }

    protected Instances getInstances() throws Exception {
        Instances result = new Instances((Reader)new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("weka/core/neighboursearch/anneal.arff"))));
        result.setClassIndex(result.numAttributes() - 1);
        return result;
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        result.setOptionHandler((OptionHandler)this.getNearestNeighbourSearch());
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject((Object)this.getNearestNeighbourSearch());
        result.setIgnoredProperties(result.getIgnoredProperties() + ",instances");
        result.setSilent(true);
        return result;
    }

    public abstract NearestNeighbourSearch getNearestNeighbourSearch();

    protected void setUp() throws Exception {
        this.m_NearestNeighbourSearch = this.getNearestNeighbourSearch();
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_Instances = this.getInstances();
        this.m_NumNeighbors = 3;
        this.m_Random = new Random(1L);
    }

    protected void tearDown() {
        this.m_NearestNeighbourSearch = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_Instances = null;
        this.m_NumNeighbors = 0;
        this.m_Random = null;
    }

    public void testSerialVersionUID() {
        boolean result;
        boolean bl = result = !SerializationHelper.needsUID(this.m_NearestNeighbourSearch.getClass());
        if (!result) {
            AbstractNearestNeighbourSearchTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    public void testListOptions() {
        if (!this.m_OptionTester.checkListOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (!this.m_OptionTester.checkDefaultOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (!this.m_OptionTester.checkRemainingOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (!this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            AbstractNearestNeighbourSearchTest.fail((String)"Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractNearestNeighbourSearchTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractNearestNeighbourSearchTest.fail((String)"Tool tips inconsistent");
        }
    }

    public void testNumberOfNeighbors() {
        try {
            this.m_NearestNeighbourSearch.setInstances(this.m_Instances);
        }
        catch (Exception e) {
            AbstractNearestNeighbourSearchTest.fail((String)("Failed setting the instances: " + e));
        }
        for (int i = 1; i <= this.m_NumNeighbors; ++i) {
            int instIndex = this.m_Random.nextInt(this.m_Instances.numInstances());
            try {
                Instances neighbors = this.m_NearestNeighbourSearch.kNearestNeighbours(this.m_Instances.instance(instIndex), i);
                AbstractNearestNeighbourSearchTest.assertEquals((String)"Returned different number of neighbors than requested", (int)i, (int)neighbors.numInstances());
                continue;
            }
            catch (Exception e) {
                AbstractNearestNeighbourSearchTest.fail((String)("Failed for " + i + " neighbors on instance " + (instIndex + 1) + ": " + e));
            }
        }
    }

    public void testBuildInitialization() {
        int m;
        int n;
        String[][][] results = new String[2][this.m_Instances.numInstances()][this.m_NumNeighbors];
        for (int i = 0; i < 2; ++i) {
            try {
                this.m_NearestNeighbourSearch.setInstances(this.m_Instances);
                for (n = 0; n < this.m_Instances.numInstances(); ++n) {
                    for (m = 1; m <= this.m_NumNeighbors; ++m) {
                        Instances inst = this.m_NearestNeighbourSearch.kNearestNeighbours(this.m_Instances.instance(n), m);
                        results[i][n][m - 1] = inst.toString();
                    }
                }
                continue;
            }
            catch (Exception e) {
                AbstractNearestNeighbourSearchTest.fail((String)("Build " + (i + 1) + " failed: " + e));
            }
        }
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            for (m = 1; m <= this.m_NumNeighbors; ++m) {
                if (results[0][n][m - 1].equals(results[1][n][m - 1])) continue;
                AbstractNearestNeighbourSearchTest.fail((String)("Results differ: instance #" + (n + 1) + " with " + m + " neighbors"));
            }
        }
    }

    protected FastVector useNearestNeighbourSearch(Instances data) throws Exception {
        this.m_NearestNeighbourSearch.setInstances(this.m_Instances);
        FastVector result = new FastVector();
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            StringBuffer item = new StringBuffer(i + 1 + ". " + this.m_Instances.instance(i).toString() + ": ");
            for (int n = 1; n <= this.m_NumNeighbors; ++n) {
                Instances inst = this.m_NearestNeighbourSearch.kNearestNeighbours(this.m_Instances.instance(i), n);
                item.append(" neighbors=" + n + ": ");
                for (int m = 0; m < inst.numInstances(); ++m) {
                    if (m > 0) {
                        item.append("; ");
                    }
                    item.append("neighbor_" + (m + 1) + "=" + inst.instance(m));
                }
            }
            result.addElement((Object)item.toString());
        }
        return result;
    }

    protected String resultsToString(FastVector results) {
        StringBuffer sb = new StringBuffer();
        sb.append(results.size()).append(" results for " + this.m_Instances.relationName() + ":\n");
        for (int i = 0; i < results.size(); ++i) {
            sb.append(results.elementAt(i)).append('\n');
        }
        return sb.toString();
    }

    public void testRegression() {
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        try {
            FastVector regressionResult = this.useNearestNeighbourSearch(this.m_Instances);
            reg.println(this.resultsToString(regressionResult));
        }
        catch (Exception e) {
            AbstractNearestNeighbourSearchTest.fail((String)("Regression test failed: " + e));
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractNearestNeighbourSearchTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractNearestNeighbourSearchTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }
}

