/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.complete.benchmark;

import java.util.LinkedList;
import java.util.Random;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DenseFileMatrix;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.objectmatrix.impl.SerializedSparseObjectMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.ehcache.EhcacheSparseObjectMatrix;
import org.ujmp.jdbc.JDBCSparseObjectMatrix;
import org.ujmp.lucene.LuceneSparseObjectMatrix;

public class VeryLargeMatrixBenchmark {
    public static final int MATRIXSIZE = 10000;
    public static final int MAXTIME = 30;
    public static final int BURNINTIME = 10;
    public static final int MAXENTRYCOUNT = 100000;

    public static void main(String[] args) throws Exception {
        System.out.println("Disk Matrix Benchmark");
        System.out.println("=====================");
        System.out.println("This benchmark creates a very large matrix on disk");
        System.out.println("and measures the time for reading and writing data");
        System.out.println();
        System.out.println("Matrix size: 10000x10000");
        System.out.println("Main Memory: " + Runtime.getRuntime().maxMemory() / 1000000L + "M");
        System.out.println();
        LinkedList<AbstractGenericMatrix> matricesToTest = new LinkedList<AbstractGenericMatrix>();
        matricesToTest.add(new DenseFileMatrix(10000L, 10000L));
        matricesToTest.add(new SerializedSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new LuceneSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new JDBCSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new EhcacheSparseObjectMatrix(10000L, 10000L));
        for (Matrix matrix : matricesToTest) {
            System.out.println(matrix.getClass().getSimpleName());
            VeryLargeMatrixBenchmark.runPerformanceTest(matrix);
            if (!(matrix instanceof Erasable)) continue;
            ((Erasable)((Object)matrix)).erase();
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void runPerformanceTest(Matrix m) throws Exception {
        seed = t = System.currentTimeMillis();
        random = new Random();
        while (System.currentTimeMillis() - t < 10000L) {
            value = MathUtil.nextDouble();
            m.setAsObject(value, new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        t = System.currentTimeMillis();
        random = new Random(seed);
        writtenEntryCount = 0;
        while (System.currentTimeMillis() - t < 30000L && writtenEntryCount < 100000) {
            value = MathUtil.nextDouble();
            m.setAsObject(value, new long[]{random.nextInt(10000), random.nextInt(10000)});
            ++writtenEntryCount;
        }
        System.out.println(" Writing random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, writtenEntryCount, -1);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        random = new Random();
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v = m.getAsDouble(new long[]{row, col});
            ++readEntryCount;
            if (v == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        random = new Random();
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < 100000) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v = m.getAsDouble(new long[]{row, col});
            m.setAsDouble(v + 1.0, new long[]{row, col});
            ++readEntryCount;
            if (v == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading/writing random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        random = new Random(seed);
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < writtenEntryCount) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v = m.getAsDouble(new long[]{row, col});
            ++readEntryCount;
            if (v == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading random non-zero entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        t = System.currentTimeMillis();
        random = new Random(seed);
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < writtenEntryCount) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v = m.getAsDouble(new long[]{row, col});
            m.setAsDouble(v + 1.0, new long[]{row, col});
            ++readEntryCount;
            if (v == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading/writing random non-zero entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        if (!(m instanceof LuceneSparseObjectMatrix)) ** GOTO lbl95
        System.out.println();
        return;
lbl-1000:
        // 1 sources

        {
            value = MathUtil.nextDouble();
            m.setAsObject(value, new long[]{random.nextInt(10000), random.nextInt(10000)});
lbl95:
            // 2 sources

            ** while (System.currentTimeMillis() - t < 10000L)
        }
lbl96:
        // 1 sources

        t = System.currentTimeMillis();
        writtenEntryCount = 0;
        r = 0L;
        while (r < m.getRowCount()) {
            c = 0L;
            while (r < m.getColumnCount()) {
                value = MathUtil.nextDouble();
                m.setAsObject(value, new long[]{r, c++});
                if (System.currentTimeMillis() - t > 30000L || ++writtenEntryCount > 100000) break;
            }
            ++r;
        }
        System.out.println(" Writing consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, writtenEntryCount, -1);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        r = 0L;
        while (r < m.getRowCount()) {
            c = 0L;
            while (r < m.getColumnCount()) {
                v = m.getAsDouble(new long[]{r, c});
                ++readEntryCount;
                if (v != 0.0) {
                    ++hitCount;
                }
                if (System.currentTimeMillis() - t > 30000L || readEntryCount > writtenEntryCount) break;
                ++c;
            }
            ++r;
        }
        System.out.println(" Reading consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(new long[]{random.nextInt(10000), random.nextInt(10000)});
        }
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        r = 0L;
        while (r < m.getRowCount()) {
            c = 0L;
            while (r < m.getColumnCount()) {
                v = m.getAsDouble(new long[]{r, c});
                m.setAsDouble(v + 1.0, new long[]{r, c});
                ++readEntryCount;
                if (v != 0.0) {
                    ++hitCount;
                }
                if (System.currentTimeMillis() - t > 30000L || readEntryCount > writtenEntryCount) break;
                ++c;
            }
            ++r;
        }
        System.out.println(" Reading/writing consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        System.out.println();
    }

    private static void printStatistics(long time, int count, int hits) {
        double speed = (double)count / (double)time * 1000.0;
        double throughput = speed * 8.0 / 1000.0;
        System.out.println("  time: " + time / 1000L + "s");
        if (hits >= 0) {
            System.out.println("  count: " + hits + " hits of " + count);
        } else {
            System.out.println("  count: " + count);
        }
        System.out.println("  speed: " + speed + " entries/s");
        System.out.println("  throughput: " + throughput + " KB/s");
    }
}

