/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.stub.AbstractDenseBooleanMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class DefaultDenseBooleanMatrix2D
extends AbstractDenseBooleanMatrix2D {
    private static final long serialVersionUID = -4334380160318525360L;
    private boolean[][] values = null;

    public DefaultDenseBooleanMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof DefaultDenseBooleanMatrix2D) {
            boolean[][] v = ((DefaultDenseBooleanMatrix2D)m).values;
            this.values = new boolean[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new boolean[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsBoolean(m.getAsBoolean(c), c);
            }
        }
    }

    public DefaultDenseBooleanMatrix2D(boolean[] ... v) {
        this.values = v;
    }

    public DefaultDenseBooleanMatrix2D(long ... size) {
        this.values = new boolean[(int)size[0]][(int)size[1]];
    }

    public DefaultDenseBooleanMatrix2D(boolean ... v) {
        this.values = new boolean[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public boolean getBoolean(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBoolean(boolean value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public boolean getBoolean(int row, int column) {
        return this.values[row][column];
    }

    public void setBoolean(boolean value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        boolean[][] result = new boolean[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new DefaultDenseBooleanMatrix2D(result);
    }
}

