/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.calculation.DivideMatrixCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DivideMatrixDenseDoubleMatrix2D
implements DivideMatrixCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    DivideMatrixDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
        if (source1 instanceof HasColumnMajorDoubleArray1D && source2 instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.calc(((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D(), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source1 instanceof HasRowMajorDoubleArray2D && source2 instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calc(((HasRowMajorDoubleArray2D)((Object)source1)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)source2)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            VerifyUtil.assertSameSize(source1, source2, target);
            int r = (int)source1.getRowCount();
            while (--r != -1) {
                int c = (int)source1.getColumnCount();
                while (--c != -1) {
                    target.setDouble(source1.getDouble(r, c) / source2.getDouble(r, c), r, c);
                }
            }
        }
    }

    @Override
    private final void calc(final double[][] source1, final double[][] source2, final double[][] target) {
        VerifyUtil.assertSameSize(source1, source2, target);
        if (UJMPSettings.getNumberOfThreads() > 1 && source1.length >= 100 && source1[0].length >= 100) {
            new PForEquidistant(0, source1.length - 1, new Object[0]){

                public void step(int i) {
                    double[] v1 = source1[i];
                    double[] v2 = source2[i];
                    double[] t = target[i];
                    int c = source1[0].length;
                    while (--c != -1) {
                        t[c] = v1[c] / v2[c];
                    }
                }
            };
        } else {
            double[] v1 = null;
            double[] v2 = null;
            double[] t = null;
            int r = source1.length;
            while (--r != -1) {
                v1 = source1[r];
                v2 = source2[r];
                t = target[r];
                int c = source1[0].length;
                while (--c != -1) {
                    t[c] = v1[c] / v2[c];
                }
            }
        }
    }

    @Override
    private final void calc(double[] source1, double[] source2, double[] target) {
        VerifyUtil.assertSameSize(source1, source2, target);
        int length = source1.length;
        int i = 0;
        while (i < length) {
            target[i] = source1[i] / source2[i];
            ++i;
        }
    }
}

