/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.charmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.charmatrix.CharMatrix;
import org.ujmp.core.charmatrix.calculation.CharCalculation;
import org.ujmp.core.charmatrix.impl.CharCalculationMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class AbstractCharCalculation
extends AbstractCalculation
implements CharCalculation {
    private static final long serialVersionUID = -3251131937680203514L;

    public AbstractCharCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractCharCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final CharMatrix calcNew() throws MatrixException {
        CharMatrix result = (CharMatrix)MatrixFactory.zeros(ValueType.CHAR, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsChar(this.getChar(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final CharMatrix calcLink() throws MatrixException {
        return new CharCalculationMatrix(this);
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsChar(this.getChar(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setChar(char value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.CHAR;
    }
}

