/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.entrywise.trigonometric;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;

public class Tan
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8951036874489201088L;

    public Tan(Matrix matrix) {
        super(matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        return Math.tan(this.getSource().getAsDouble(coordinates));
    }

    public static Matrix calc(Matrix source) throws MatrixException {
        Matrix ret = Matrix.factory.zeros(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            ret.setAsDouble(Math.tan(source.getAsDouble(c)), c);
        }
        return ret;
    }
}

