/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.util.concurrent.Callable;
import org.ujmp.core.doublematrix.impl.BlockDenseDoubleMatrix2D;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockMultiply
implements Callable<Void> {
    private final int blockStripeSize;
    private final int fromM;
    private final int toM;
    private final int fromN;
    private final int toN;
    private final int fromK;
    private final int toK;
    private final BlockDenseDoubleMatrix2D matrixA;
    private final BlockDenseDoubleMatrix2D matrixB;
    private final BlockDenseDoubleMatrix2D matrixC;

    public BlockMultiply(BlockDenseDoubleMatrix2D a, BlockDenseDoubleMatrix2D b, BlockDenseDoubleMatrix2D c, int fromM, int toM, int fromN, int toN, int fromK, int toK) {
        BlockMultiply.verifyInput(a, b, c, fromM, toM, fromN, toN, fromK, toK);
        this.matrixA = a;
        this.matrixB = b;
        this.matrixC = c;
        this.fromM = fromM;
        this.toM = toM;
        this.fromN = fromN;
        this.toN = toN;
        this.fromK = fromK;
        this.toK = toK;
        this.blockStripeSize = a.layout.blockStripe;
    }

    @Override
    public Void call() {
        this.multiply();
        return null;
    }

    protected final void multiply() {
        int step = this.blockStripeSize;
        int blockSize = this.blockStripeSize * this.blockStripeSize;
        int m = this.fromM;
        while (m < this.toM) {
            int aRows = this.matrixA.layout.getRowsInBlock(m);
            int k = this.fromK;
            while (k < this.toK) {
                int bCols = this.matrixB.layout.getColumnsInBlock(k);
                double[] cBlock = new double[aRows * bCols];
                int n = this.fromN;
                while (n < this.toN) {
                    double[] aBlock = this.matrixA.layout.toRowMajorBlock(this.matrixA, m, n);
                    double[] bBlock = this.matrixB.layout.toColMajorBlock(this.matrixB, n, k);
                    if (aBlock != null && bBlock != null) {
                        if (aBlock.length == blockSize && bBlock.length == blockSize) {
                            BlockMultiply.multiplyAxB(aBlock, bBlock, cBlock, step);
                        } else {
                            int aCols = aBlock.length / aRows;
                            int bRows = bBlock.length / bCols;
                            VerifyUtil.assertTrue(aCols == bRows, "aCols!=bRows");
                            this.multiplyRowMajorTimesColumnMajorBlocks(aBlock, bBlock, cBlock, aRows, aCols, bCols);
                        }
                    }
                    n += step;
                }
                this.matrixC.addBlockData(m, k, cBlock);
                k += step;
            }
            m += step;
        }
    }

    private static void multiplyAxB(double[] aBlock, double[] bBlock, double[] cBlock, int step) {
        int blockStripeMini = step % 3;
        int blockStripeMaxi = step / 3;
        int blockArea = step * step;
        int iL = 0;
        while (iL < blockArea) {
            int rc = iL;
            int kL = 0;
            while (kL < blockArea) {
                int ra = iL;
                int rb = kL;
                double sum = 0.0;
                int jL = blockStripeMini;
                while (--jL >= 0) {
                    sum += aBlock[ra++] * bBlock[rb++];
                }
                jL = blockStripeMaxi;
                while (--jL >= 0) {
                    sum += aBlock[ra++] * bBlock[rb++] + aBlock[ra++] * bBlock[rb++] + aBlock[ra++] * bBlock[rb++];
                }
                int n = rc++;
                cBlock[n] = cBlock[n] + sum;
                kL += step;
            }
            iL += step;
        }
    }

    public void multiplyRowMajorTimesColumnMajorBlocks(double[] aBlock, double[] bBlock, double[] cBlock, int aRows, int bRows, int bCols) {
        int aCols = bRows;
        int i = 0;
        while (i < aRows) {
            int k = 0;
            while (k < bCols) {
                double sum = 0.0;
                int j = 0;
                while (j < bRows) {
                    sum += aBlock[i * aCols + j] * bBlock[k * bRows + j];
                    ++j;
                }
                int n = i * bCols + k;
                cBlock[n] = cBlock[n] + sum;
                ++k;
            }
            ++i;
        }
    }

    private static void verifyInput(BlockDenseDoubleMatrix2D a, BlockDenseDoubleMatrix2D b, BlockDenseDoubleMatrix2D c, int fromM, int toM, int fromN, int toN, int fromK, int toK) {
        VerifyUtil.assertTrue(a != null, "a cannot be null");
        VerifyUtil.assertTrue(b != null, "b cannot be null");
        VerifyUtil.assertTrue(c != null, "c cannot be null");
        VerifyUtil.assertTrue((long)fromM <= a.getRowCount() && fromM >= 0, "Invalid argument : fromM");
        VerifyUtil.assertTrue((long)toM <= a.getRowCount() && toM >= fromM, "Invalid argument : fromM/toM");
        VerifyUtil.assertTrue((long)fromN <= a.getColumnCount() && fromN >= 0, "Invalid argument : fromN");
        VerifyUtil.assertTrue((long)toN <= a.getColumnCount() && toN >= fromN, "Invalid argument : fromN/toN");
        VerifyUtil.assertTrue((long)fromK <= b.getColumnCount() && fromK >= 0, "Invalid argument : fromK");
        VerifyUtil.assertTrue((long)toK <= b.getColumnCount() && toK >= fromK, "Invalid argument : fromK/toK");
        VerifyUtil.assertTrue(a.getColumnCount() == b.getRowCount(), "Invalid argument : a.columns != b.rows");
        VerifyUtil.assertTrue(a.getRowCount() == c.getRowCount(), "Invalid argument : a.rows != c.rows");
        VerifyUtil.assertTrue(b.getColumnCount() == c.getColumnCount(), "Invalid argument : b.columns != c.columns");
    }
}

