/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.FloatMatrix;
import org.ujmp.core.floatmatrix.calculation.FloatCalculation;
import org.ujmp.core.floatmatrix.impl.FloatCalculationMatrix;

public abstract class AbstractFloatCalculation
extends AbstractCalculation
implements FloatCalculation {
    private static final long serialVersionUID = 7992575645594878948L;

    public AbstractFloatCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractFloatCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final FloatMatrix calcLink() throws MatrixException {
        return new FloatCalculationMatrix(this);
    }

    public final FloatMatrix calcNew() throws MatrixException {
        FloatMatrix result = (FloatMatrix)MatrixFactory.zeros(ValueType.FLOAT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsFloat(this.getFloat(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsFloat(this.getFloat(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setFloat(float value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.FLOAT;
    }
}

