/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class SimpleDenseObjectMatrix2D
extends AbstractDenseObjectMatrix2D {
    private static final long serialVersionUID = -7051381548902586972L;
    private Object[][] values = null;

    public SimpleDenseObjectMatrix2D(Object[] ... values) {
        this.values = values;
    }

    public SimpleDenseObjectMatrix2D(long ... size) {
        this.values = new Object[(int)size[0]][(int)size[1]];
    }

    public SimpleDenseObjectMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof SimpleDenseObjectMatrix2D) {
            Object[][] v = ((SimpleDenseObjectMatrix2D)m).values;
            this.values = new Object[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new Object[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setObject(m.getAsObject(c), c);
            }
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public Object getObject(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setObject(Object value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public Object getObject(int row, int column) {
        return this.values[row][column];
    }

    public void setObject(Object value, int row, int column) {
        this.values[row][column] = value;
    }
}

