/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;

public class FileListMatrix
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = -2627484975560893624L;
    private List<File> files = null;

    public FileListMatrix(String path) {
        this(new File(path));
    }

    public FileListMatrix(File path) {
        this.files = Arrays.asList(path.listFiles());
        Collections.sort(this.files);
        this.setMatrixAnnotation(path);
    }

    public long[] getSize() {
        return new long[]{this.files.size(), 2L};
    }

    public String getString(long row, long column) {
        switch ((int)column) {
            case 0: {
                File f = this.files.get((int)row);
                return f.getName();
            }
            case 1: {
                return "" + this.files.get((int)row).length();
            }
        }
        return null;
    }

    public void setString(String value, long row, long column) {
        if (column == 0L && row < (long)this.files.size()) {
            File source = this.files.get((int)row);
            File target = new File(String.valueOf(source.getParent()) + File.separator + value);
            source.renameTo(target);
            this.files.set((int)row, target);
        }
    }
}

