/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class IntelligentFileReader
extends Reader {
    private static final Logger logger = Logger.getLogger(IntelligentFileReader.class.getName());
    private FileReader fr = null;
    private InputStream zip = null;
    private LineNumberReader lr = null;
    private String encoding = "UTF-8";

    public IntelligentFileReader(String file) {
        this(new File(file));
    }

    public IntelligentFileReader(InputStream inputStream) {
        try {
            this.lr = new LineNumberReader(new InputStreamReader(inputStream, this.encoding));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not open stream", e);
        }
    }

    public IntelligentFileReader(Reader reader) {
        try {
            this.lr = new LineNumberReader(reader);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not open stream", e);
        }
    }

    public IntelligentFileReader(File file) {
        if (file != null && file.exists()) {
            if (file.getAbsolutePath().toLowerCase().endsWith(".gz")) {
                try {
                    this.zip = new GZIPInputStream(new FileInputStream(file));
                    this.lr = new LineNumberReader(new InputStreamReader(this.zip, this.encoding));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            } else if (file.getAbsolutePath().toLowerCase().endsWith(".z")) {
                try {
                    this.zip = new ZipInputStream(new FileInputStream(file));
                    this.lr = new LineNumberReader(new InputStreamReader(this.zip, this.encoding));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            } else {
                try {
                    this.fr = new FileReader(file);
                    this.lr = new LineNumberReader(this.fr);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "could not open file " + file, e);
                }
            }
        } else {
            logger.log(Level.WARNING, "cannot open file: " + file);
        }
    }

    public IntelligentFileReader(URLConnection connection) throws IOException {
        this(connection.getInputStream());
    }

    public String readLine() {
        if (this.lr == null) {
            return null;
        }
        try {
            return this.lr.readLine();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not read line", e);
            return null;
        }
    }

    public void close() {
        try {
            if (this.lr != null) {
                this.lr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.fr != null) {
                this.fr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLineNumber() {
        if (this.lr != null) {
            return this.lr.getLineNumber();
        }
        return -1;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.lr.read(cbuf, off, len);
    }

    public static String load(String filename) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(filename);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(String.valueOf(line) + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(File filename) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(filename);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(String.valueOf(line) + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(InputStream stream) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(stream);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(String.valueOf(line) + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static String load(Reader reader) {
        StringBuilder s = new StringBuilder();
        IntelligentFileReader fr = new IntelligentFileReader(reader);
        String line = null;
        while ((line = fr.readLine()) != null) {
            s.append(String.valueOf(line) + "\n");
        }
        fr.close();
        return s.toString();
    }

    public static byte[] readBytes(File file) {
        try {
            byte[] data = new byte[(int)file.length()];
            FileInputStream fi = new FileInputStream(file);
            BufferedInputStream bi = new BufferedInputStream(fi);
            bi.read(data);
            bi.close();
            fi.close();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

