/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.util.ConcurrentModificationException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.util.ColorUtil;
import org.ujmp.gui.util.TooltipUtil;

public class MatrixValueTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1473046176750819621L;
    private static final Color SELECTCOLOR = new Color(200, 200, 255);
    private final Border border = BorderFactory.createLineBorder(Color.blue, 2);

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        label.setHorizontalAlignment(0);
        MatrixGUIObject m = (MatrixGUIObject)table.getModel();
        Color c = ColorUtil.fromObject(value);
        try {
            this.setToolTipText(TooltipUtil.getTooltip(m, row, column));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        int width = table.getColumnModel().getColumn(column).getWidth();
        if (width < 25) {
            label.setText("");
        } else {
            String s = UJMPFormat.getSingleLineInstance().format(value);
            if (s != null && s.length() > 100) {
                s = String.valueOf(s.substring(0, 100)) + "...";
            }
            label.setText(s);
        }
        label.setForeground(ColorUtil.contrastBW(c));
        label.setBackground(c);
        if (isSelected) {
            label.setBorder(this.border);
        } else {
            label.setBorder(null);
        }
        return label;
    }
}

