/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.DB;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;

public class ImportMatrixJDBC {
    public static ObjectMatrix2D fromDatabase(String url, String sqlStatement, String username, String password) throws Exception {
        if (url.startsWith("jdbc:mysql://")) {
            Class.forName("com.mysql.jdbc.Driver");
        } else if (url.startsWith("jdbc:postgresql://")) {
            Class.forName("org.postgresql.Driver");
        } else {
            throw new MatrixException("Database format not supported: " + url);
        }
        Connection connection = DriverManager.getConnection(url, username, password);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sqlStatement);
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        long columnCount = rsMetaData.getColumnCount();
        resultSet.last();
        long rowCount = resultSet.getRow();
        resultSet.first();
        ObjectMatrix2D m = (ObjectMatrix2D)MatrixFactory.zeros(ValueType.OBJECT, rowCount, columnCount);
        int c = 0;
        while ((long)c < columnCount) {
            m.setColumnLabel(c, rsMetaData.getColumnLabel(c + 1));
            ++c;
        }
        int r = 0;
        while ((long)r < rowCount) {
            int c2 = 0;
            while ((long)c2 < columnCount) {
                m.setObject(resultSet.getObject(c2 + 1), r, c2);
                ++c2;
            }
            resultSet.next();
            ++r;
        }
        resultSet.close();
        statement.close();
        connection.close();
        return m;
    }

    public static ObjectMatrix2D fromDatabase(DB type, String host, int port, String databasename, String sqlStatement, String username, String password) throws Exception {
        switch (type) {
            case MySQL: {
                return ImportMatrixJDBC.fromDatabase("jdbc:mysql://" + host + ":" + port + "/" + databasename, sqlStatement, username, password);
            }
        }
        throw new MatrixException("not supported: " + (Object)((Object)type));
    }
}

