/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jmathplot;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.math.plot.Plot2DPanel;
import org.ujmp.core.Matrix;
import org.ujmp.jmathplot.AbstractJMathPlotPanel;

public class JMathPlotScatterPanel
extends AbstractJMathPlotPanel {
    private static final long serialVersionUID = -4535556358042506549L;

    public JMathPlotScatterPanel(Matrix matrix) {
        super(matrix);
    }

    public void repaintUI() {
        Matrix matrix = this.getMatrix();
        String xLabel = matrix.getColumnLabel(0L);
        xLabel = xLabel == null ? "Column 0" : xLabel;
        String yLabel = null;
        if (matrix.getColumnCount() == 2L) {
            yLabel = matrix.getColumnLabel(1L);
        }
        yLabel = yLabel == null ? "Value" : yLabel;
        Plot2DPanel panel = new Plot2DPanel();
        double[] x = new double[(int)this.getMatrix().getRowCount()];
        int r = 0;
        while ((long)r < matrix.getRowCount()) {
            x[r] = matrix.getAsDouble(r, 0L);
            ++r;
        }
        int c = 1;
        while ((long)c < matrix.getColumnCount()) {
            double[] y = new double[(int)matrix.getRowCount()];
            int r2 = 0;
            while ((long)r2 < matrix.getRowCount()) {
                y[r2] = matrix.getAsDouble(r2, c);
                ++r2;
            }
            String colLabel = matrix.getColumnLabel(c);
            colLabel = colLabel == null ? "Column " + c : colLabel;
            panel.addScatterPlot(colLabel, x, y);
            ++c;
        }
        panel.setAxisLabels(new String[]{xLabel, yLabel});
        panel.addLegend("SOUTH");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.setPanel((JPanel)panel);
        this.getParent().repaint();
    }
}

