/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.owlpack;

import edu.rice.linpack.Matrix.DMatrix.DFull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlpackDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DFull> {
    private static final long serialVersionUID = 1341952001270932703L;
    private transient DFull matrix = null;

    public OwlpackDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DFull((int)size[0], (int)size[1]);
    }

    public OwlpackDenseDoubleMatrix2D(Matrix m) {
        this(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setDouble(m.getAsDouble(c), c);
        }
    }

    public OwlpackDenseDoubleMatrix2D(DFull matrix) {
        this.matrix = matrix;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getElem(row, column);
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getElem((int)row, (int)column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.numofRows(), this.matrix.numofCols()};
    }

    @Override
    public DFull getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof OwlpackDenseDoubleMatrix2D) {
            DFull mo = ((OwlpackDenseDoubleMatrix2D)m).getWrappedObject();
            DFull result = this.matrix.matMult(mo);
            return new OwlpackDenseDoubleMatrix2D(result);
        }
        return super.mtimes(m);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setElem(row, column, value);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setElem((int)row, (int)column, value);
    }

    @Override
    public void setWrappedObject(DFull object) {
        this.matrix = object;
    }

    @Override
    public Matrix transpose() {
        DFull result = new DFull((int)this.getColumnCount(), (int)this.getRowCount());
        this.matrix.transpose(result);
        return new OwlpackDenseDoubleMatrix2D(result);
    }

    @Override
    public Matrix inv() {
        DFull result = new DFull(this.matrix);
        result.inverse();
        return new OwlpackDenseDoubleMatrix2D(result);
    }

    @Override
    public Matrix[] svd() {
        int p = (int)this.getRowCount();
        int n = (int)this.getColumnCount();
        double[] S = new double[Math.min(n + 1, p)];
        double[] E = new double[p];
        DFull U = new DFull(n, Math.min(n, p));
        DFull V = new DFull(p, p);
        this.matrix.svDecompose(S, E, U, V, 2);
        OwlpackDenseDoubleMatrix2D u = new OwlpackDenseDoubleMatrix2D(U);
        OwlpackDenseDoubleMatrix2D v = new OwlpackDenseDoubleMatrix2D(V);
        OwlpackDenseDoubleMatrix2D s = new OwlpackDenseDoubleMatrix2D(S.length, S.length);
        int i = 0;
        while (i < S.length) {
            s.setAsDouble(S[i], new long[]{i, i});
            ++i;
        }
        return new Matrix[]{u, s, v};
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] data = (double[][])s.readObject();
        int rows = data.length;
        int cols = data[0].length;
        this.matrix = new DFull(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                this.setDouble(data[r][c], r, c);
                ++c;
            }
            ++r;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }
}

