/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.sst;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix;
import org.ujmp.core.util.CoordinateIterator;
import org.ujmp.core.util.MathUtil;
import shared.array.IntegerArray;

public class SSTDenseIntMatrix
extends AbstractDenseIntMatrix
implements Wrapper<IntegerArray> {
    private static final long serialVersionUID = 2319673263310965476L;
    private transient IntegerArray data = null;

    public SSTDenseIntMatrix(IntegerArray data) {
        this.data = data;
    }

    public SSTDenseIntMatrix(long ... size) {
        this.data = new IntegerArray(MathUtil.toIntArray(size), new int[0]);
    }

    public SSTDenseIntMatrix(Matrix source) {
        this.data = new IntegerArray(MathUtil.toIntArray(source.getSize()), new int[0]);
        for (long[] c : source.availableCoordinates()) {
            this.setInt(source.getAsInt(c), c);
        }
    }

    @Override
    public int getInt(long ... coordinates) throws MatrixException {
        return this.data.get(MathUtil.toIntArray(coordinates));
    }

    @Override
    public void setInt(int value, long ... coordinates) throws MatrixException {
        this.data.set(value, MathUtil.toIntArray(coordinates));
    }

    @Override
    public long[] getSize() {
        return MathUtil.toLongArray(this.data.dimensions());
    }

    @Override
    public Iterable<long[]> allCoordinates() throws MatrixException {
        return new CoordinateIterator(this.getSize());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        byte[] bytes = (byte[])s.readObject();
        this.data = IntegerArray.parse((byte[])bytes);
    }

    private void writeObject(ObjectOutputStream s) throws IOException, MatrixException {
        s.defaultWriteObject();
        s.writeObject(this.data.getBytes());
    }

    @Override
    public IntegerArray getWrappedObject() {
        return this.data;
    }

    @Override
    public void setWrappedObject(IntegerArray object) {
        this.data = object;
    }
}

