/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import java.io.Serializable;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.experiment.Stats;
import weka.filters.unsupervised.attribute.Add;

public class CobWeb
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public FloatOption acuityOption = new FloatOption("acuity", 'a', "Acuity (minimum standard deviation)", 1.0, 0.0, 90.0);
    public FloatOption cutoffOption = new FloatOption("cutoff", 'c', "Cutoff (minimum category utility)", 0.002, 0.0, 90.0);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    protected static final double m_normal = 1.0 / (2.0 * Math.sqrt(Math.PI));
    protected double m_acuity = 1.0;
    protected double m_cutoff = 0.002;
    protected CNode m_cobwebTree = null;
    protected int m_numberOfClusters = -1;
    protected boolean m_numberOfClustersDetermined = false;
    protected int m_numberSplits;
    protected int m_numberMerges;
    protected boolean m_saveInstances = false;
    public static final String classifierPurposeString = "Cobweb and Classit clustering algorithms: it always compares the best host, adding a new leaf, merging the two best hosts, and splitting the best host when considering where to place a new instance..";

    public void resetLearningImpl() {
        this.setAcuity(this.acuityOption.getValue());
        this.setCutoff(this.cutoffOption.getValue());
        this.m_numberOfClusters = -1;
        this.m_cobwebTree = null;
        this.m_numberSplits = 0;
        this.m_numberMerges = 0;
    }

    public void trainOnInstanceImpl(Instance newInstance) {
        this.m_numberOfClustersDetermined = false;
        if (this.m_cobwebTree == null) {
            this.m_cobwebTree = new CNode(newInstance.numAttributes(), newInstance);
        } else {
            this.m_cobwebTree.addInstance(newInstance);
        }
    }

    public double[] getVotesForInstance(Instance instance) {
        CNode host = this.m_cobwebTree;
        CNode temp = null;
        this.determineNumberOfClusters();
        if (this.m_numberOfClusters < 1) {
            return new double[0];
        }
        double[] ret = new double[this.m_numberOfClusters];
        do {
            if (host.m_children == null) {
                temp = null;
                break;
            }
            host.updateStats(instance, false);
            temp = host.findHost(instance, true);
            host.updateStats(instance, true);
            if (temp == null) continue;
            host = temp;
        } while (temp != null);
        ret[((CNode)host).m_clusterNum] = 1.0;
        return ret;
    }

    protected void determineNumberOfClusters() {
        if (!this.m_numberOfClustersDetermined && this.m_cobwebTree != null) {
            int[] numClusts = new int[]{0};
            this.m_cobwebTree.assignClusterNums(numClusts);
            this.m_numberOfClusters = numClusts[0];
            this.m_numberOfClustersDetermined = true;
        }
    }

    public int numberOfClusters() {
        this.determineNumberOfClusters();
        return this.m_numberOfClusters;
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        StringBuffer text = new StringBuffer();
        if (this.m_cobwebTree == null) {
            StringUtils.appendIndented(out, indent, "Cobweb hasn't been built yet!");
            StringUtils.appendNewline(out);
        } else {
            this.m_cobwebTree.dumpTree(0, text);
            StringUtils.appendIndented(out, indent, "CobWeb - ");
            out.append("Number of merges: " + this.m_numberMerges + "\nNumber of splits: " + this.m_numberSplits + "\nNumber of clusters: " + this.numberOfClusters() + "\n" + text.toString());
            StringUtils.appendNewline(out);
        }
    }

    public boolean isRandomizable() {
        return false;
    }

    public String graph() {
        StringBuffer text = new StringBuffer();
        text.append("digraph CobwebTree {\n");
        this.m_cobwebTree.graphTree(text);
        text.append("}\n");
        return text.toString();
    }

    public void setAcuity(double a) {
        this.m_acuity = a;
    }

    public double getAcuity() {
        return this.m_acuity;
    }

    public void setCutoff(double c) {
        this.m_cutoff = c;
    }

    public double getCutoff() {
        return this.m_cutoff;
    }

    public boolean getSaveInstanceData() {
        return this.m_saveInstances;
    }

    public void setSaveInstanceData(boolean newsaveInstances) {
        this.m_saveInstances = newsaveInstances;
    }

    public Clustering getClusteringResult() {
        Clustering result = new Clustering();
        if (this.m_cobwebTree != null) {
            this.m_cobwebTree.computeTreeClustering(0, result);
            System.out.println("After Number of clusters: " + this.numberOfClusters());
        }
        System.out.println("Number of clusters: " + result.size());
        return result;
    }

    private class CNode
    implements Serializable {
        static final long serialVersionUID = 3452097436933325631L;
        private AttributeStats[] m_attStats;
        private int m_numAttributes;
        protected Instances m_clusterInstances = null;
        private FastVector m_children = null;
        private double m_totalInstances = 0.0;
        private int m_clusterNum = -1;

        public CNode(int numAttributes) {
            this.m_numAttributes = numAttributes;
        }

        public CNode(int numAttributes, Instance leafInstance) {
            this(numAttributes);
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new Instances(leafInstance.dataset(), 1);
            }
            this.m_clusterInstances.add(leafInstance);
            this.updateStats(leafInstance, false);
        }

        protected void addInstance(Instance newInstance) {
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new Instances(newInstance.dataset(), 1);
                this.m_clusterInstances.add(newInstance);
                this.updateStats(newInstance, false);
                return;
            }
            if (this.m_children == null) {
                this.m_children = new FastVector();
                CNode tempSubCluster = new CNode(this.m_numAttributes, this.m_clusterInstances.instance(0));
                for (int i = 1; i < this.m_clusterInstances.numInstances(); ++i) {
                    tempSubCluster.m_clusterInstances.add(this.m_clusterInstances.instance(i));
                    tempSubCluster.updateStats(this.m_clusterInstances.instance(i), false);
                }
                this.m_children = new FastVector();
                this.m_children.addElement((Object)tempSubCluster);
                this.m_children.addElement((Object)new CNode(this.m_numAttributes, newInstance));
                this.m_clusterInstances.add(newInstance);
                this.updateStats(newInstance, false);
                if (this.categoryUtility() < CobWeb.this.m_cutoff) {
                    this.m_children = null;
                }
                return;
            }
            CNode bestHost = this.findHost(newInstance, false);
            if (bestHost != null) {
                bestHost.addInstance(newInstance);
            }
        }

        private double[] cuScoresForChildren(Instance newInstance) {
            double[] categoryUtils = new double[this.m_children.size()];
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode temp = (CNode)this.m_children.elementAt(i);
                temp.updateStats(newInstance, false);
                categoryUtils[i] = this.categoryUtility();
                temp.updateStats(newInstance, true);
            }
            return categoryUtils;
        }

        private double cuScoreForBestTwoMerged(CNode merged, CNode a, CNode b, Instance newInstance) {
            double mergedCU = -1.7976931348623157E308;
            merged.m_clusterInstances = new Instances(this.m_clusterInstances, 1);
            merged.addChildNode(a);
            merged.addChildNode(b);
            merged.updateStats(newInstance, false);
            this.m_children.removeElementAt(this.m_children.indexOf((Object)a));
            this.m_children.removeElementAt(this.m_children.indexOf((Object)b));
            this.m_children.addElement((Object)merged);
            mergedCU = this.categoryUtility();
            merged.updateStats(newInstance, true);
            this.m_children.removeElementAt(this.m_children.indexOf((Object)merged));
            this.m_children.addElement((Object)a);
            this.m_children.addElement((Object)b);
            return mergedCU;
        }

        private CNode findHost(Instance newInstance, boolean structureFrozen) {
            if (!structureFrozen) {
                this.updateStats(newInstance, false);
            }
            double[] categoryUtils = this.cuScoresForChildren(newInstance);
            CNode newLeaf = new CNode(this.m_numAttributes, newInstance);
            this.m_children.addElement((Object)newLeaf);
            double bestHostCU = this.categoryUtility();
            CNode finalBestHost = newLeaf;
            this.m_children.removeElementAt(this.m_children.size() - 1);
            int best = 0;
            int secondBest = 0;
            for (int i = 0; i < categoryUtils.length; ++i) {
                if (!(categoryUtils[i] > categoryUtils[secondBest])) continue;
                if (categoryUtils[i] > categoryUtils[best]) {
                    secondBest = best;
                    best = i;
                    continue;
                }
                secondBest = i;
            }
            CNode a = (CNode)this.m_children.elementAt(best);
            CNode b = (CNode)this.m_children.elementAt(secondBest);
            if (categoryUtils[best] > bestHostCU) {
                bestHostCU = categoryUtils[best];
                finalBestHost = a;
            }
            if (structureFrozen) {
                if (finalBestHost == newLeaf) {
                    return null;
                }
                return finalBestHost;
            }
            double mergedCU = -1.7976931348623157E308;
            CNode merged = new CNode(this.m_numAttributes);
            if (a != b && (mergedCU = this.cuScoreForBestTwoMerged(merged, a, b, newInstance)) > bestHostCU) {
                bestHostCU = mergedCU;
                finalBestHost = merged;
            }
            double splitCU = -1.7976931348623157E308;
            double splitBestChildCU = -1.7976931348623157E308;
            double splitPlusNewLeafCU = -1.7976931348623157E308;
            double splitPlusMergeBestTwoCU = -1.7976931348623157E308;
            if (a.m_children != null) {
                int i;
                FastVector tempChildren = new FastVector();
                for (i = 0; i < this.m_children.size(); ++i) {
                    CNode existingChild = (CNode)this.m_children.elementAt(i);
                    if (existingChild == a) continue;
                    tempChildren.addElement((Object)existingChild);
                }
                for (i = 0; i < a.m_children.size(); ++i) {
                    CNode promotedChild = (CNode)a.m_children.elementAt(i);
                    tempChildren.addElement((Object)promotedChild);
                }
                tempChildren.addElement((Object)newLeaf);
                FastVector saveStatusQuo = this.m_children;
                this.m_children = tempChildren;
                splitPlusNewLeafCU = this.categoryUtility();
                tempChildren.removeElementAt(tempChildren.size() - 1);
                categoryUtils = this.cuScoresForChildren(newInstance);
                best = 0;
                secondBest = 0;
                for (int i2 = 0; i2 < categoryUtils.length; ++i2) {
                    if (!(categoryUtils[i2] > categoryUtils[secondBest])) continue;
                    if (categoryUtils[i2] > categoryUtils[best]) {
                        secondBest = best;
                        best = i2;
                        continue;
                    }
                    secondBest = i2;
                }
                CNode sa = (CNode)this.m_children.elementAt(best);
                CNode sb = (CNode)this.m_children.elementAt(secondBest);
                splitBestChildCU = categoryUtils[best];
                CNode mergedSplitChildren = new CNode(this.m_numAttributes);
                if (sa != sb) {
                    splitPlusMergeBestTwoCU = this.cuScoreForBestTwoMerged(mergedSplitChildren, sa, sb, newInstance);
                }
                splitCU = splitBestChildCU > splitPlusNewLeafCU ? splitBestChildCU : splitPlusNewLeafCU;
                double d = splitCU = splitCU > splitPlusMergeBestTwoCU ? splitCU : splitPlusMergeBestTwoCU;
                if (splitCU > bestHostCU) {
                    bestHostCU = splitCU;
                    finalBestHost = this;
                } else {
                    this.m_children = saveStatusQuo;
                }
            }
            if (finalBestHost != this) {
                this.m_clusterInstances.add(newInstance);
            } else {
                ++CobWeb.this.m_numberSplits;
            }
            if (finalBestHost == merged) {
                ++CobWeb.this.m_numberMerges;
                this.m_children.removeElementAt(this.m_children.indexOf((Object)a));
                this.m_children.removeElementAt(this.m_children.indexOf((Object)b));
                this.m_children.addElement((Object)merged);
            }
            if (finalBestHost == newLeaf) {
                finalBestHost = new CNode(this.m_numAttributes);
                this.m_children.addElement((Object)finalBestHost);
            }
            if (bestHostCU < CobWeb.this.m_cutoff) {
                if (finalBestHost == this) {
                    this.m_clusterInstances.add(newInstance);
                }
                this.m_children = null;
                finalBestHost = null;
            }
            if (finalBestHost == this) {
                this.updateStats(newInstance, true);
            }
            return finalBestHost;
        }

        protected void addChildNode(CNode child) {
            for (int i = 0; i < child.m_clusterInstances.numInstances(); ++i) {
                Instance temp = child.m_clusterInstances.instance(i);
                this.m_clusterInstances.add(temp);
                this.updateStats(temp, false);
            }
            if (this.m_children == null) {
                this.m_children = new FastVector();
            }
            this.m_children.addElement((Object)child);
        }

        protected double categoryUtility() {
            double totalCU = 0.0;
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode child = (CNode)this.m_children.elementAt(i);
                totalCU += this.categoryUtilityChild(child);
            }
            return totalCU /= (double)this.m_children.size();
        }

        protected double categoryUtilityChild(CNode child) {
            double sum = 0.0;
            for (int i = 0; i < this.m_numAttributes; ++i) {
                if (this.m_clusterInstances.attribute(i).isNominal()) {
                    for (int j = 0; j < this.m_clusterInstances.attribute(i).numValues(); ++j) {
                        double x = child.getProbability(i, j);
                        double y = this.getProbability(i, j);
                        sum += x * x - y * y;
                    }
                    continue;
                }
                sum += m_normal / child.getStandardDev(i) - m_normal / this.getStandardDev(i);
            }
            return child.m_totalInstances / this.m_totalInstances * sum;
        }

        protected double getProbability(int attIndex, int valueIndex) {
            if (this.m_attStats[attIndex].totalCount <= 0) {
                return 0.0;
            }
            return (double)this.m_attStats[attIndex].nominalCounts[valueIndex] / (double)this.m_attStats[attIndex].totalCount;
        }

        protected double getStandardDev(int attIndex) {
            this.m_attStats[attIndex].numericStats.calculateDerived();
            double stdDev = this.m_attStats[attIndex].numericStats.stdDev;
            if (Double.isNaN(stdDev) || Double.isInfinite(stdDev)) {
                return CobWeb.this.m_acuity;
            }
            return Math.max(CobWeb.this.m_acuity, stdDev);
        }

        protected void updateStats(Instance updateInstance, boolean delete) {
            int i;
            if (this.m_attStats == null) {
                this.m_attStats = new AttributeStats[this.m_numAttributes];
                for (i = 0; i < this.m_numAttributes; ++i) {
                    this.m_attStats[i] = new AttributeStats();
                    if (this.m_clusterInstances.attribute(i).isNominal()) {
                        this.m_attStats[i].nominalCounts = new int[this.m_clusterInstances.attribute(i).numValues()];
                        continue;
                    }
                    this.m_attStats[i].numericStats = new Stats();
                }
            }
            for (i = 0; i < this.m_numAttributes; ++i) {
                if (updateInstance.isMissing(i)) continue;
                double value = updateInstance.value(i);
                if (this.m_clusterInstances.attribute(i).isNominal()) {
                    int n = (int)value;
                    this.m_attStats[i].nominalCounts[n] = (int)((double)this.m_attStats[i].nominalCounts[n] + (delete ? -1.0 * updateInstance.weight() : updateInstance.weight()));
                    this.m_attStats[i].totalCount = (int)((double)this.m_attStats[i].totalCount + (delete ? -1.0 * updateInstance.weight() : updateInstance.weight()));
                    continue;
                }
                if (delete) {
                    this.m_attStats[i].numericStats.subtract(value, updateInstance.weight());
                    continue;
                }
                this.m_attStats[i].numericStats.add(value, updateInstance.weight());
            }
            this.m_totalInstances += delete ? -1.0 * updateInstance.weight() : updateInstance.weight();
        }

        private void assignClusterNums(int[] cl_num) {
            this.m_clusterNum = cl_num[0];
            cl_num[0] = cl_num[0] + 1;
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    CNode child = (CNode)this.m_children.elementAt(i);
                    child.assignClusterNums(cl_num);
                }
            }
        }

        protected void dumpTree(int depth, StringBuffer text) {
            if (depth == 0) {
                CobWeb.this.determineNumberOfClusters();
            }
            if (this.m_children == null) {
                text.append("\n");
                for (int j = 0; j < depth; ++j) {
                    text.append("|   ");
                }
                text.append("leaf " + this.m_clusterNum + " [" + this.m_clusterInstances.numInstances() + "]");
            } else {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    text.append("\n");
                    for (int j = 0; j < depth; ++j) {
                        text.append("|   ");
                    }
                    text.append("node " + this.m_clusterNum + " [" + this.m_clusterInstances.numInstances() + "]");
                    ((CNode)this.m_children.elementAt(i)).dumpTree(depth + 1, text);
                }
            }
        }

        protected String dumpData() {
            if (this.m_children == null) {
                return this.m_clusterInstances.toString();
            }
            CNode tempNode = new CNode(this.m_numAttributes);
            tempNode.m_clusterInstances = new Instances(this.m_clusterInstances, 1);
            for (int i = 0; i < this.m_children.size(); ++i) {
                tempNode.addChildNode((CNode)this.m_children.elementAt(i));
            }
            Instances tempInst = tempNode.m_clusterInstances;
            tempNode = null;
            Add af = new Add();
            af.setAttributeName("Cluster");
            String labels = "";
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode temp = (CNode)this.m_children.elementAt(i);
                labels = labels + "C" + temp.m_clusterNum;
                if (i >= this.m_children.size() - 1) continue;
                labels = labels + ",";
            }
            af.setNominalLabels(labels);
            tempInst.setRelationName("Cluster " + this.m_clusterNum);
            int z = 0;
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode temp = (CNode)this.m_children.elementAt(i);
                for (int j = 0; j < temp.m_clusterInstances.numInstances(); ++j) {
                    tempInst.instance(z).setValue(this.m_numAttributes, (double)i);
                    ++z;
                }
            }
            return tempInst.toString();
        }

        protected void graphTree(StringBuffer text) {
            text.append("N" + this.m_clusterNum + " [label=\"" + (this.m_children == null ? "leaf " : "node ") + this.m_clusterNum + " " + " (" + this.m_clusterInstances.numInstances() + ")\" " + (this.m_children == null ? "shape=box style=filled " : "") + (CobWeb.this.m_saveInstances ? "data =\n" + this.dumpData() + "\n,\n" : "") + "]\n");
            if (this.m_children != null) {
                CNode temp;
                int i;
                for (i = 0; i < this.m_children.size(); ++i) {
                    temp = (CNode)this.m_children.elementAt(i);
                    text.append("N" + this.m_clusterNum + "->" + "N" + temp.m_clusterNum + "\n");
                }
                for (i = 0; i < this.m_children.size(); ++i) {
                    temp = (CNode)this.m_children.elementAt(i);
                    temp.graphTree(text);
                }
            }
        }

        protected void computeTreeClustering(int depth, Clustering clustering) {
            if (depth == 0) {
                CobWeb.this.determineNumberOfClusters();
            }
            if (this.m_children == null) {
                if (depth == 0) {
                    double[] centroidCoordinates = new double[this.m_clusterInstances.numAttributes()];
                    for (int j = 0; j < this.m_clusterInstances.numAttributes() - 1; ++j) {
                        centroidCoordinates[j] = this.m_clusterInstances.meanOrMode(j);
                    }
                    clustering.add(new SphereCluster(centroidCoordinates, 0.05, this.m_clusterInstances.numInstances()));
                }
            } else {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    double[] centroidCoordinates = new double[this.m_clusterInstances.numAttributes()];
                    for (int j = 0; j < this.m_clusterInstances.numAttributes() - 1; ++j) {
                        centroidCoordinates[j] = this.m_clusterInstances.meanOrMode(j);
                    }
                    clustering.add(new SphereCluster(centroidCoordinates, 0.05, this.m_clusterInstances.numInstances()));
                    ((CNode)this.m_children.elementAt(i)).computeTreeClustering(depth + 1, clustering);
                }
            }
        }
    }
}

