/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers;

import java.util.ArrayList;
import java.util.List;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.core.AutoClassDiscovery;
import moa.core.AutoExpandVector;
import moa.core.Measurement;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.options.MultiChoiceOption;
import moa.options.StringOption;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaClusteringAlgorithm
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption horizonOption = new IntOption("horizon", 'h', "Range of the window.", 1000);
    public MultiChoiceOption wekaAlgorithmOption;
    public StringOption parameterOption = new StringOption("parameter", 'p', "Parameters that will be passed to the weka algorithm. (e.g. '-N 5' for using SimpleKmeans with 5 clusters)", "-N 5 -S 8");
    private Class<?>[] clustererClasses = this.findWekaClustererClasses();
    private Instances instances;
    private weka.clusterers.AbstractClusterer clusterer;

    public WekaClusteringAlgorithm() {
        String[] optionLabels = new String[this.clustererClasses.length];
        String[] optionDescriptions = new String[this.clustererClasses.length];
        for (int i = 0; i < this.clustererClasses.length; ++i) {
            optionLabels[i] = this.clustererClasses[i].getSimpleName();
            optionDescriptions[i] = this.clustererClasses[i].getName();
        }
        if (this.clustererClasses != null && this.clustererClasses.length > 0) {
            this.wekaAlgorithmOption = new MultiChoiceOption("clusterer", 'w', "Weka cluster algorithm to use.", optionLabels, optionDescriptions, 6);
        } else {
            this.horizonOption = null;
            this.parameterOption = null;
        }
    }

    @Override
    public void resetLearningImpl() {
        try {
            this.instances = null;
            String clistring = this.clustererClasses[this.wekaAlgorithmOption.getChosenIndex()].getName();
            this.clusterer = (weka.clusterers.AbstractClusterer)ClassOption.cliStringToObject(clistring, Clusterer.class, null);
            String rawOptions = this.parameterOption.getValue();
            String[] options = rawOptions.split(" ");
            if (this.clusterer instanceof OptionHandler) {
                ((OptionHandler)this.clusterer).setOptions(options);
                Utils.checkForRemainingOptions((String[])options);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.instances == null) {
            this.instances = this.getDataset(inst.numAttributes(), 0);
        }
        this.instances.add(inst);
    }

    @Override
    public Clustering getClusteringResult() {
        Clustering clustering = null;
        try {
            this.clusterer.buildClusterer(this.instances);
            int numClusters = this.clusterer.numberOfClusters();
            Instances dataset = this.getDataset(this.instances.numAttributes(), numClusters);
            Instances newInstances = new Instances(dataset);
            for (int i = 0; i < this.instances.numInstances(); ++i) {
                Instance inst = this.instances.get(i);
                int cnum = this.clusterer.clusterInstance(inst);
                DenseInstance newInst = new DenseInstance(inst);
                newInst.insertAttributeAt(inst.numAttributes());
                newInst.setDataset(dataset);
                newInst.setClassValue((double)cnum);
                newInstances.add((Instance)newInst);
            }
            clustering = new Clustering((List<? extends Instance>)newInstances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.instances = null;
        return clustering;
    }

    public Instances getDataset(int numdim, int numclass) {
        FastVector attributes = new FastVector();
        for (int i = 0; i < numdim; ++i) {
            attributes.addElement((Object)new Attribute("att" + (i + 1)));
        }
        if (numclass > 0) {
            FastVector classLabels = new FastVector();
            for (int i = 0; i < numclass; ++i) {
                classLabels.addElement((Object)("class" + (i + 1)));
            }
            attributes.addElement((Object)new Attribute("class", (List)classLabels));
        }
        Instances myDataset = new Instances("horizion", (ArrayList)attributes, 0);
        if (numclass > 0) {
            myDataset.setClassIndex(myDataset.numAttributes() - 1);
        }
        return myDataset;
    }

    private Class<?>[] findWekaClustererClasses() {
        Class[] classesFound;
        AutoExpandVector<Class> finalClasses = new AutoExpandVector<Class>();
        for (Class foundClass : classesFound = AutoClassDiscovery.findClassesOfType("weka.clusterers", weka.clusterers.AbstractClusterer.class)) {
            finalClasses.add(foundClass);
        }
        return finalClasses.toArray(new Class[finalClasses.size()]);
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    @Override
    public boolean keepClassLabel() {
        return false;
    }

    @Override
    public String getPurposeString() {
        String purpose = "MOA Clusterer: " + this.getClass().getCanonicalName();
        if (this.clustererClasses == null || this.clustererClasses.length == 0) {
            purpose = purpose + "\nPlease add weka.jar to the classpath to use Weka clustering algorithms.";
        }
        return purpose;
    }
}

