/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import moa.gui.OptionEditComponent;
import moa.options.FloatOption;
import moa.options.Option;

public class FloatOptionEditComponent
extends JPanel
implements OptionEditComponent {
    private static final long serialVersionUID = 1L;
    public static final int SLIDER_RESOLUTION = 100000;
    protected FloatOption editedOption;
    protected JSpinner spinner;
    protected JSlider slider;

    public FloatOptionEditComponent(FloatOption option) {
        this.editedOption = option;
        double minVal = option.getMinValue();
        double maxVal = option.getMaxValue();
        this.setLayout(new GridLayout(1, 0));
        this.spinner = new JSpinner(new SpinnerNumberModel(option.getValue(), minVal, maxVal, 0.001));
        this.add(this.spinner);
        if (minVal > Double.NEGATIVE_INFINITY && maxVal < Double.POSITIVE_INFINITY) {
            this.slider = new JSlider(0, 100000, this.floatValueToSliderValue(option.getValue()));
            this.add(this.slider);
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    FloatOptionEditComponent.this.spinner.setValue(FloatOptionEditComponent.this.sliderValueToFloatValue(FloatOptionEditComponent.this.slider.getValue()));
                }
            });
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    FloatOptionEditComponent.this.slider.setValue(FloatOptionEditComponent.this.floatValueToSliderValue((Double)FloatOptionEditComponent.this.spinner.getValue()));
                }
            });
        }
    }

    protected int floatValueToSliderValue(double floatValue) {
        double minVal = this.editedOption.getMinValue();
        double maxVal = this.editedOption.getMaxValue();
        return (int)Math.round((floatValue - minVal) / (maxVal - minVal) * 100000.0);
    }

    protected double sliderValueToFloatValue(int sliderValue) {
        double minVal = this.editedOption.getMinValue();
        double maxVal = this.editedOption.getMaxValue();
        return minVal + (double)sliderValue / 100000.0 * (maxVal - minVal);
    }

    public void applyState() {
        this.editedOption.setValue((Double)this.spinner.getValue());
    }

    public Option getEditedOption() {
        return this.editedOption;
    }

    public void setEditState(String cliString) {
        this.spinner.setValue(FloatOption.cliStringToDouble(cliString));
    }
}

