/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import moa.core.InstancesHeader;
import moa.core.MultilabelInstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaMultilabelGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption binaryGeneratorOption = new ClassOption("binaryGenerator", 's', "Binary Generator (use this option to specify the number of attributes, but specify two classes only).", InstanceStream.class, "generators.RandomTreeGenerator");
    public IntOption metaRandomSeedOption = new IntOption("metaRandomSeed", 'm', "Random seed (for the meta process).", 1);
    public IntOption numLabelsOption = new IntOption("numLabels", 'c', "Number of labels.", 1);
    public IntOption skewOption = new IntOption("skew", 'k', "Skewed label distribution: 1 (default) = yes; 0 = no (relatively uniform).", 1, 0, 1);
    public FloatOption labelCardinalityOption = new FloatOption("labelCardinality", 'z', "Target label cardinality of resulting set", 1.5, 0.0, 2.147483647E9);
    protected MultilabelInstancesHeader m_MultilabelInstancesHeader = null;
    protected InstanceStream m_BinaryGenerator = null;
    protected Instances multilabelStreamTemplate = null;
    protected Random m_MetaRandom = null;
    protected int m_N = 0;
    protected int m_A = 0;
    protected double m_Z = 0.0;
    protected double[] skew = null;
    protected double[] skew_n = null;
    protected double[][] matrix = null;
    protected ArrayList[] m_FeatureEffects = null;
    LinkedList<Instance>[] queue = null;

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
    }

    @Override
    public void restart() {
        this.m_N = this.numLabelsOption.getValue();
        this.m_BinaryGenerator = (InstanceStream)this.getPreparedClassOption(this.binaryGeneratorOption);
        this.m_BinaryGenerator.restart();
        this.m_A = this.m_BinaryGenerator.getHeader().numAttributes() - 1;
        this.m_MetaRandom = new Random(this.metaRandomSeedOption.getValue());
        this.queue = new LinkedList[2];
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = new LinkedList();
        }
        this.m_MultilabelInstancesHeader = this.generateMultilabelHeader(this.m_BinaryGenerator.getHeader());
        double z = this.m_Z = this.labelCardinalityOption.getValue();
        while (true) {
            this.skew = this.fillSkew(this.m_MetaRandom, z);
            this.skew_n = Arrays.copyOf(this.skew, this.skew.length);
            Utils.normalize((double[])this.skew_n);
            this.matrix = this.fillMatrix(this.skew, this.m_Z / (double)this.m_N, this.m_MetaRandom);
            double total = 0.0;
            for (int i = 0; i < 10000; ++i) {
                total += (double)this.generateSet(this.discreteRandomIndex(this.skew_n)).size();
            }
            if ((total /= 10000.0) - this.m_Z < -0.1) {
                z += 0.1;
                continue;
            }
            if (!(total - this.m_Z > 0.1)) break;
            z -= 0.1;
        }
        this.m_FeatureEffects = this.getTopCombinations(this.m_N * 2);
    }

    protected MultilabelInstancesHeader generateMultilabelHeader(Instances si) {
        Instances mi = new Instances(si, 0, 0);
        mi.setClassIndex(-1);
        mi.deleteAttributeAt(mi.numAttributes() - 1);
        FastVector bfv = new FastVector();
        bfv.addElement((Object)"0");
        bfv.addElement((Object)"1");
        for (int i = 0; i < this.m_N; ++i) {
            mi.insertAttributeAt(new Attribute("class" + i, (List)bfv), i);
        }
        this.multilabelStreamTemplate = mi;
        this.multilabelStreamTemplate.setRelationName("SYN_Z" + this.labelCardinalityOption.getValue() + "L" + this.m_N + "X" + this.m_A + "S" + this.metaRandomSeedOption.getValue() + ": -C " + this.m_N);
        this.multilabelStreamTemplate.setClassIndex(this.m_N);
        return new MultilabelInstancesHeader(this.multilabelStreamTemplate, this.m_N);
    }

    private double[] fillSkew(Random r, double z) {
        int i;
        double[] d = new double[this.m_N];
        for (i = 0; i < this.m_N; ++i) {
            d[i] = this.skewOption.getValue() >= 1 ? this.m_MetaRandom.nextDouble() : 1.0;
        }
        Utils.normalize((double[])d, (double)(Utils.sum((double[])d) / z));
        for (i = 0; i < this.m_N; ++i) {
            if (!Double.isNaN(d[i])) continue;
            d[i] = 0.01;
        }
        return d;
    }

    private Instance getNextWithBinary(int i) {
        int lim = 1000;
        if (this.queue[i].size() <= 0) {
            int c = -1;
            while (lim-- > 0) {
                Instance tinst = this.m_BinaryGenerator.nextInstance();
                c = (int)Math.round(tinst.classValue());
                if (i == c) {
                    return tinst;
                }
                if (this.queue[c].size() >= 100) continue;
                this.queue[c].add(tinst);
            }
            System.err.println("[Overflow] The binary stream is too skewed, could not get an example of class " + i + "");
            System.exit(1);
            return null;
        }
        return this.queue[i].remove();
    }

    private int labelCorrelation(ArrayList<Integer> lbls) {
        double[] r = new double[this.m_N];
        Arrays.fill(r, 1.0);
        for (int l : lbls) {
            for (int j = 0; j < this.matrix[l].length; ++j) {
                r[j] = j == l ? 0.0 : r[j] * this.matrix[j][l];
            }
        }
        return this.discreteRandomIndex(r);
    }

    @Override
    public Instance nextInstance() {
        try {
            return this.generateMLInstance(this.generateSet(this.discreteRandomIndex(this.skew_n)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private ArrayList generateSet(int l) {
        ArrayList<Integer> lbls = new ArrayList<Integer>();
        while (l >= 0) {
            lbls.add(l);
            l = this.labelCorrelation(lbls);
        }
        return lbls;
    }

    private Instance generateMLInstance(ArrayList<Integer> lbls) throws Exception {
        int i;
        SparseInstance ml_x = new SparseInstance(this.multilabelStreamTemplate.numAttributes());
        ml_x.setDataset(this.multilabelStreamTemplate);
        for (i = 0; i < this.m_N; ++i) {
            ml_x.setValue(i, 0.0);
        }
        for (i = 0; i < lbls.size(); ++i) {
            ml_x.setValue(lbls.get(i).intValue(), 1.0);
        }
        Instance binary0 = this.getNextWithBinary(0);
        Instance binary1 = this.getNextWithBinary(1);
        for (int a = 0; a < this.m_A; ++a) {
            if (lbls.containsAll(this.m_FeatureEffects[a % this.m_FeatureEffects.length])) {
                ml_x.setValue(this.m_N + a, binary1.value(a));
                continue;
            }
            ml_x.setValue(this.m_N + a, binary0.value(a));
        }
        return ml_x;
    }

    private int discreteRandomIndex(double[] p) {
        double r = this.m_MetaRandom.nextDouble();
        if (Utils.sum((double[])p) <= r || Double.isNaN(Utils.sum((double[])p))) {
            return -1;
        }
        int i = 0;
        for (double sum = 0.0; r > sum; sum += p[i++]) {
            if (i < p.length) continue;
            return -1;
        }
        return i - 1;
    }

    protected static double genE(int i, double L) {
        return L * Math.pow(Math.E, -L * (double)i);
    }

    protected double[][] fillMatrix(double[] skew, double Z, Random r) {
        int i;
        this.matrix = new double[skew.length][skew.length];
        for (i = 0; i < skew.length; ++i) {
            this.matrix[i][i] = Utils.roundDouble((double)skew[i], (int)3);
        }
        for (i = 0; i < this.matrix.length; ++i) {
            for (int j = i + 1; j < this.matrix[i].length; ++j) {
                if (r.nextDouble() <= Z * 2.0) {
                    this.matrix[i][j] = this.randFromRange(this.min(this.P(i), this.P(j)), this.max(this.P(i), this.P(j)));
                    this.matrix[j][i] = this.matrix[i][j] * this.matrix[i][i] / this.matrix[j][j];
                } else {
                    this.matrix[i][j] = this.min(this.P(i), this.P(j));
                    this.matrix[j][i] = this.matrix[i][j] * this.matrix[j][j] / this.matrix[i][i];
                }
                this.matrix[i][j] = Utils.roundDouble((double)this.matrix[i][j], (int)3);
                this.matrix[j][i] = Utils.roundDouble((double)this.matrix[j][i], (int)3);
            }
        }
        return this.matrix;
    }

    protected double randFromRange(double min, double max) {
        return min + MetaMultilabelGenerator.genE(this.m_MetaRandom.nextInt(5), max - min);
    }

    protected double P(int i) {
        return this.matrix[i][i];
    }

    protected double P(int i, int j) {
        return this.matrix[i][j];
    }

    protected double max(double A, double B) {
        return Math.min(1.0, B / A);
    }

    protected double min(double A, double B) {
        return Math.max(0.0, -1.0 + A + B);
    }

    private ArrayList[] getTopCombinations(int n) {
        HashMap<String, Integer> top = new HashMap<String, Integer>();
        for (int i = 0; i < 10000; ++i) {
            String s;
            top.put(s, top.get(s = MetaMultilabelGenerator.arrayToString(this.generateSet(this.discreteRandomIndex(this.skew_n)), this.m_N)) != null ? top.get(s) + 1 : 1);
        }
        HashMap<String, Integer> rating = MetaMultilabelGenerator.getAsReverseSortedHashMap(top);
        ArrayList[] al = new ArrayList[rating.size()];
        int i = 0;
        for (String s : rating.keySet()) {
            al[i++] = MetaMultilabelGenerator.stringToArray(s);
        }
        return al;
    }

    private static HashMap<String, Integer> getAsReverseSortedHashMap(HashMap<String, Integer> c) {
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        for (String wsState : c.keySet()) {
            tempMap.put(wsState, c.get(wsState));
        }
        ArrayList mapKeys = new ArrayList(tempMap.keySet());
        ArrayList mapValues = new ArrayList(tempMap.values());
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        TreeSet sortedSet = new TreeSet(mapValues);
        Object[] sortedArray = sortedSet.toArray();
        int size = sortedArray.length;
        for (int i = 0; i < size; ++i) {
            sortedMap.put((String)mapKeys.get(mapValues.indexOf(sortedArray[size - 1 - i])), (Integer)sortedArray[size - 1 - i]);
        }
        return sortedMap;
    }

    private static ArrayList stringToArray(String s) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '1') continue;
            al.add(i);
        }
        return al;
    }

    private static String arrayToString(ArrayList<Integer> lbls, int N) {
        StringBuilder sb = new StringBuilder(N);
        for (int i = 0; i < N; ++i) {
            sb.append('0');
        }
        for (int l : lbls) {
            sb.setCharAt(l, '1');
        }
        return sb.toString();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.m_MultilabelInstancesHeader;
    }

    @Override
    public String getPurposeString() {
        return "Generates a multi-label stream using a binary generator.";
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

