/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

public class IEEE754 {
    public static double toDouble(double i) {
        long l = (long)i;
        double ret = Float.intBitsToFloat(IEEE754.longToIntBits(l));
        if (Double.isNaN(ret)) {
            System.err.println("Encountered non-IEEE 754 floating-point value");
            return Double.NaN;
        }
        return ret;
    }

    public static int longToIntBits(long l) {
        int ret = (int)(l >> 24);
        ret <<= 8;
        ret |= (int)(l >> 16 & 0xFFL);
        ret <<= 8;
        ret |= (int)(l >> 8 & 0xFFL);
        ret <<= 8;
        return ret |= (int)(l & 0xFFL);
    }

    public static long toIntBits(double d) {
        float f = (float)d;
        int i = Float.floatToRawIntBits(f);
        long l = 0L;
        return l | (long)i;
    }

    public static byte[] floatToIntBitsLittleEndian(Float f) {
        byte[] ret = new byte[4];
        int i = Float.floatToRawIntBits(f.floatValue());
        ret[0] = (byte)(ret[0] | (i & 0xFF000000) >> 24);
        ret[1] = (byte)(ret[1] | (i & 0xFF0000) >> 16);
        ret[2] = (byte)(ret[2] | (i & 0xFF00) >> 8);
        ret[3] = (byte)(ret[3] | i & 0xFF);
        return ret;
    }

    public static double[] toDoubleArray(double[] in) {
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = IEEE754.toDouble(in[i]);
        }
        return ret;
    }

    public static double[] toIntBitsArray(double[] in) {
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = IEEE754.toIntBits(in[i]);
        }
        return ret;
    }
}

