/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class SortedList<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 2084694193825707653L;
    protected ArrayList<T> m_List = new ArrayList();
    protected Comparator m_Comparator;

    public SortedList() {
        this(new ComparableComparator());
    }

    public SortedList(Collection<T> o) {
        this((Comparator)new ComparableComparator(), o);
    }

    public SortedList(SortedList<T> o) {
        this((Comparator)new ComparableComparator(), o);
    }

    public SortedList(T[] o) {
        this(new ComparableComparator(), (Serializable[])o);
    }

    public SortedList(Comparator comparator) {
        this.m_Comparator = comparator;
    }

    public SortedList(Comparator comparator, Collection<T> o) {
        this(comparator);
        this.addAll(o);
    }

    public SortedList(Comparator comparator, SortedList<T> o) {
        this(comparator);
        this.addAll(o);
    }

    public SortedList(Comparator comparator, T[] o) {
        this(comparator);
        this.addAll(Arrays.asList(o));
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    public synchronized void clear() {
        this.m_List.clear();
    }

    public synchronized int size() {
        return this.m_List.size();
    }

    public synchronized void add(T o) {
        int index = Collections.binarySearch(this.m_List, o, this.getComparator());
        if (index < 0) {
            this.m_List.add(-index - 1, o);
        } else {
            this.m_List.add(index, o);
        }
    }

    public synchronized void addAll(Collection<T> o) {
        for (Serializable item : o) {
            this.add(item);
        }
    }

    public synchronized void addAll(SortedList<T> o) {
        Iterator<T> iter = o.iterator();
        while (iter.hasNext()) {
            this.add((Serializable)iter.next());
        }
    }

    public synchronized T remove(int index) {
        return (T)((Serializable)this.m_List.remove(index));
    }

    public synchronized T get(int index) {
        return (T)((Serializable)this.m_List.get(index));
    }

    public synchronized T first() {
        return (T)((Serializable)this.m_List.get(0));
    }

    public synchronized T last() {
        return (T)((Serializable)this.m_List.get(this.m_List.size() - 1));
    }

    public synchronized Iterator<T> iterator() {
        return this.m_List.iterator();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("comparator=");
        result.append(this.m_Comparator.toString());
        result.append(", list=");
        result.append(this.m_List.toString());
        return result.toString();
    }

    public static class ComparableComparator
    implements Comparator<Comparable>,
    Serializable {
        private static final long serialVersionUID = -609207775494982996L;

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    }
}

