/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.CleanUpHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class AbstractOption
implements Serializable,
CleanUpHandler {
    private static final long serialVersionUID = 8825127756251485512L;
    public static final String TOOLTIP_SUFFIX = "TipText";
    protected OptionManager m_Owner;
    protected String m_Commandline;
    protected String m_Property;
    protected Object m_DefaultValue;
    protected boolean m_OutputDefaultValue;
    protected boolean m_Debug;

    protected AbstractOption(OptionManager owner, String commandline, String property, Object defValue, boolean outputDefValue) {
        OptionUtils.registerCustomHooks();
        this.m_Owner = owner;
        this.m_Commandline = commandline;
        this.m_Property = property;
        this.m_DefaultValue = defValue;
        this.m_OutputDefaultValue = outputDefValue;
        this.m_Debug = OptionUtils.getDebug();
        if (this.m_DefaultValue == null) {
            try {
                this.m_DefaultValue = this.getDescriptor().getReadMethod().invoke((Object)this.getOptionHandler(), new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Cannot determine default value: " + this.getOptionHandler().getClass().getName() + "." + this.getProperty());
            }
        }
    }

    protected boolean getDebug() {
        return this.m_Debug;
    }

    public OptionManager getOwner() {
        return this.m_Owner;
    }

    public OptionHandler getOptionHandler() {
        return this.m_Owner.getOwner();
    }

    public String getCommandline() {
        return this.m_Commandline;
    }

    public String getProperty() {
        return this.m_Property;
    }

    public Object getDefaultValue() {
        return this.m_DefaultValue;
    }

    public Object getCurrentValue() {
        Object result;
        try {
            Method method = this.getReadMethod();
            result = method != null ? method.invoke((Object)this.getOptionHandler(), new Object[0]) : this.m_DefaultValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = this.m_DefaultValue;
        }
        return result;
    }

    public boolean getOutputDefaultValue() {
        return this.m_OutputDefaultValue;
    }

    public synchronized PropertyDescriptor getDescriptor() {
        return OptionUtils.getDescriptor(this.getOptionHandler(), this.getProperty());
    }

    public synchronized Method getToolTipMethod() {
        Method result;
        try {
            result = this.getOptionHandler().getClass().getMethod(this.getProperty() + TOOLTIP_SUFFIX, new Class[0]);
        }
        catch (Exception e) {
            result = null;
            System.err.println("Missing tooltip: " + this.getOptionHandler().getClass().getName() + "." + this.getProperty() + TOOLTIP_SUFFIX);
        }
        return result;
    }

    protected Method getReadMethod() {
        Method result = this.getDescriptor() != null ? this.getDescriptor().getReadMethod() : null;
        if (result == null) {
            System.err.println("No read method for '" + this.getProperty() + "'??");
        }
        return result;
    }

    protected Method getWriteMethod() {
        Method result = this.getDescriptor() != null ? this.getDescriptor().getWriteMethod() : null;
        if (result == null) {
            System.err.println("No write method for '" + this.getProperty() + "'??");
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Owner = null;
        this.m_DefaultValue = null;
    }
}

