/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;

public class AnyToString
extends AbstractConversion {
    private static final long serialVersionUID = 8828591710515484463L;

    @Override
    public String globalInfo() {
        return "Turns any object into a String, using its 'toString()' method. \nArrays get resolved before using the 'toString()' of its elements. Multi-dimensional arrays are handled as well.";
    }

    @Override
    public Class accepts() {
        return Object.class;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_Input.getClass().isArray()) {
            return Utils.arrayToString(this.m_Input);
        }
        return this.m_Input.toString();
    }
}

