/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.PassThrough;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class BaselineCorrection<T extends DataContainer>
extends AbstractDatabaseConnectionFilter<T> {
    private static final long serialVersionUID = -7883650579561992382L;
    protected AbstractBaselineCorrection m_BaselineCorrection;

    @Override
    public String globalInfo() {
        return "A filter that runs a baseline correction scheme over the data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("baseline", "baselineCorrection", new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setBaselineCorrection(AbstractBaselineCorrection value) {
        this.m_BaselineCorrection = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractBaselineCorrection getBaselineCorrection() {
        return this.m_BaselineCorrection;
    }

    public String baselineCorrectionTipText() {
        return "The baseline correction algorithm to use for correcting the baseline of the data.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_BaselineCorrection instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_BaselineCorrection)).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected T processData(T data) {
        AbstractBaselineCorrection baseline = this.m_BaselineCorrection.shallowCopy(true);
        T result = baseline.correct(data);
        baseline.destroy();
        return result;
    }
}

