/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.Utils;
import adams.core.io.SpreadSheet;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.statistics.EqualLengthArrayStatistic;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractArrayStatistic<T extends Serializable>
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractArrayStatistic> {
    private static final long serialVersionUID = 5803268124112742362L;
    protected Vector<T[]> m_Data;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Data = new Vector();
    }

    public void clear() {
        this.m_Data.clear();
    }

    public int size() {
        return this.m_Data.size();
    }

    public void add(T[] data) {
        this.m_Data.add(data);
    }

    public T[] get(int index) {
        return (Serializable[])this.m_Data.get(index);
    }

    public T[] set(int index, T[] data) {
        return (Serializable[])this.m_Data.set(index, data);
    }

    public T[] remove(int index) {
        return (Serializable[])this.m_Data.remove(index);
    }

    public abstract int getMin();

    public abstract int getMax();

    protected void checkEqualLength() {
        int len = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (i == 0) {
                len = this.get(i).length;
                continue;
            }
            if (len == this.get(i).length) continue;
            throw new IllegalStateException(this.getClass().getName() + ": Arrays #1 and #" + (i + 1) + " differ in length: " + len + " != " + this.get(i).length);
        }
    }

    protected void check() {
        if (this.getMin() != -1 && this.size() < this.getMin()) {
            throw new IllegalStateException(this.getClass().getName() + ": Requires at least " + this.getMin() + " arrays, current: " + this.size());
        }
        if (this.getMax() != -1 && this.size() > this.getMax()) {
            throw new IllegalStateException(this.getClass().getName() + ": Requires at most " + this.getMax() + " arrays, current: " + this.size());
        }
        if (this.getMin() != -1 && this.getMax() != -1 && this.getMin() > this.getMax()) {
            throw new IllegalStateException(this.getClass().getName() + ": Min must be smaller than max (min=" + this.getMin() + ", max=" + this.getMax() + ")!");
        }
        if (this instanceof EqualLengthArrayStatistic) {
            this.checkEqualLength();
        }
    }

    protected abstract StatisticContainer doCalculate();

    public StatisticContainer calculate() {
        this.check();
        return this.doCalculate();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append("\nStored arrays:\n");
        for (int i = 0; i < this.size(); ++i) {
            result.append(i + 1 + ".: ");
            result.append(Utils.arrayToString(this.get(i)));
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public AbstractArrayStatistic shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractArrayStatistic shallowCopy(boolean expand) {
        return (AbstractArrayStatistic)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getStatistics() {
        return ClassLister.getSingleton().getClassnames(AbstractArrayStatistic.class);
    }

    public static AbstractArrayStatistic forName(String classname, String[] options) {
        AbstractArrayStatistic result;
        try {
            result = (AbstractArrayStatistic)OptionUtils.forName(AbstractArrayStatistic.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractArrayStatistic forCommandLine(String cmdline) {
        return (AbstractArrayStatistic)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static class StatisticContainer<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 4477965744045104127L;
        protected String[] m_Header;
        protected Object[][] m_Data;
        protected Hashtable<String, Object> m_MetaData;

        public StatisticContainer(int rows, int cols) {
            this.m_Header = new String[cols];
            this.m_Data = new Object[rows][cols];
            this.m_MetaData = new Hashtable();
        }

        public void clear() {
            int i;
            for (i = 0; i < this.m_Header.length; ++i) {
                this.m_Header[i] = "";
            }
            for (i = 0; i < this.m_Data.length; ++i) {
                for (int n = 0; n < this.m_Data[i].length; ++n) {
                    this.m_Data[i] = null;
                }
            }
            this.m_MetaData.clear();
        }

        public int getColumnCount() {
            return this.m_Header.length;
        }

        public int getRowCount() {
            return this.m_Data.length;
        }

        public void setHeader(int col, String value) {
            this.m_Header[col] = value;
        }

        public String getHeader(int col) {
            return this.m_Header[col];
        }

        public void setCell(int row, int col, T value) {
            this.m_Data[row][col] = value;
        }

        public T getCell(int row, int col) {
            return (T)((Serializable)this.m_Data[row][col]);
        }

        public void setMetaData(String key, Object value) {
            this.m_MetaData.put(key, value);
        }

        public boolean hasMetaData(String key) {
            return this.m_MetaData.containsKey(key);
        }

        public Object getMetaData(String key) {
            return this.m_MetaData.get(key);
        }

        public Enumeration<String> keysMetaData() {
            return this.m_MetaData.keys();
        }

        public SpreadSheet toSpreadSheet() {
            SpreadSheet.Cell cell;
            int i;
            SpreadSheet result = new SpreadSheet();
            SpreadSheet.Row row = result.getHeaderRow();
            for (i = 0; i < this.m_Header.length; ++i) {
                cell = row.addCell("" + (i + 1));
                cell.setContent(this.m_Header[i]);
            }
            for (int n = 0; n < this.m_Data.length; ++n) {
                row = result.addRow("" + (n + 1));
                for (i = 0; i < this.m_Data[n].length; ++i) {
                    cell = row.addCell("" + (i + 1));
                    if (this.m_Data[n][i] == null) continue;
                    cell.setContent("" + (Serializable)this.m_Data[n][i]);
                }
            }
            return result;
        }

        public String toString() {
            return this.toSpreadSheet().toString();
        }
    }
}

