/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.docbook;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public abstract class AbstractElement
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 6472066010192166545L;
    protected Hashtable<String, String> m_Attributes = new Hashtable();

    public AbstractElement(String tag) {
        super(tag);
    }

    public String getTag() {
        return (String)this.getUserObject();
    }

    public void setAttribute(String name, String value) {
        if (name.replaceAll("[a-zA-Z0-9]", "").length() > 0) {
            throw new IllegalArgumentException("Only attribute names consisting of alphanumeric characters are allowed: " + name);
        }
        this.m_Attributes.put(name, value);
    }

    public boolean hasAttribute(String name) {
        return this.m_Attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        return this.m_Attributes.get(name);
    }

    public String removeAttribute(String name) {
        return this.m_Attributes.remove(name);
    }

    protected boolean isValidChild(AbstractElement child) {
        return true;
    }

    protected void preInsert(MutableTreeNode newChild, int childIndex) {
        if (!this.isValidChild((AbstractElement)newChild)) {
            throw new IllegalArgumentException("Invalid child element: " + newChild);
        }
    }

    protected void doInsert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
    }

    protected void postInsert(MutableTreeNode newChild, int childIndex) {
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        this.preInsert(newChild, childIndex);
        this.doInsert(newChild, childIndex);
        this.postInsert(newChild, childIndex);
    }

    protected String toEntities(String s) {
        String result = s;
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("@", "&#64;");
        result = result.replace("\"", "&quot;");
        return result;
    }

    protected String getIndentation() {
        StringBuilder result = new StringBuilder();
        int level = this.getLevel();
        for (int i = 0; i < level; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    protected void appendStartTag(StringBuilder buffer) {
        buffer.append("<" + this.getTag());
        if (this.m_Attributes.size() > 0) {
            Vector<String> keys = new Vector<String>(this.m_Attributes.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                buffer.append(" ");
                buffer.append(key);
                buffer.append("=\"");
                buffer.append(this.toEntities(this.getAttribute(key)));
                buffer.append("\"");
            }
        }
        buffer.append(">");
    }

    protected void appendEndTag(StringBuilder buffer) {
        buffer.append("</" + this.getTag() + ">");
        buffer.append("\n");
    }

    protected abstract void appendContent(StringBuilder var1);

    protected void doValidate() {
    }

    public void validate() {
        this.doValidate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            AbstractElement child = (AbstractElement)this.getChildAt(i);
            child.validate();
        }
    }

    public void toXML(StringBuilder buffer) {
        String indent = this.getIndentation();
        buffer.append(indent);
        this.appendStartTag(buffer);
        if (this.getChildCount() > 0) {
            buffer.append("\n");
            this.appendContent(buffer);
            buffer.append(indent);
        } else {
            this.appendContent(buffer);
        }
        this.appendEndTag(buffer);
    }
}

