/*
 * Decompiled with CFR 0.152.
 */
package adams.env;

import adams.core.Properties;
import adams.env.Environment;
import adams.env.Setup;
import adams.gui.core.GUIHelper;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Modules {
    public static final String FILENAME = "Module.props";
    protected static Modules m_Singleton;
    protected Vector<Module> m_Modules;

    private Modules() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Modules = new Vector();
        Vector<Setup> setups = Environment.getInstance().getProperties().get("module");
        for (Setup setup : setups) {
            for (String dir : setup.getDirectories()) {
                try {
                    Enumeration<URL> urls = ClassLoader.getSystemResources(dir + "/" + setup.getFilename());
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        Properties props = new Properties();
                        props.load(url.openStream());
                        this.m_Modules.add(new Module(props));
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to list '" + dir + "/" + setup.getFilename() + "':");
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(this.m_Modules);
    }

    public List<Module> getModules() {
        return this.m_Modules;
    }

    public static synchronized Modules getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Modules();
        }
        return m_Singleton;
    }

    public static class Module
    implements Serializable,
    Comparable<Module> {
        private static final long serialVersionUID = 7936617163709734744L;
        public static final String ADAMS_PREFIX = "adams-";
        protected String m_Name;
        protected String m_Description;
        protected String m_Author;
        protected String m_Organization;
        protected ImageIcon m_Logo;

        public Module(Properties props) {
            this.m_Name = props.getProperty("Name", "Unknown");
            this.m_Description = props.getProperty("Description", "");
            this.m_Author = props.getProperty("Author", "");
            this.m_Organization = props.getProperty("Organization", "");
            String logo = props.getProperty("Logo", "");
            if (logo.length() > 0) {
                try {
                    this.m_Logo = GUIHelper.getIcon(logo);
                    if (this.m_Logo == null) {
                        this.m_Logo = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(logo));
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load image '" + logo + "' from classpath:");
                    e.printStackTrace();
                    this.m_Logo = GUIHelper.getIcon("unknown-module.png");
                }
            } else {
                this.m_Logo = GUIHelper.getIcon("default-module.png");
            }
        }

        public String getName() {
            return this.m_Name;
        }

        public String getDescription() {
            return this.m_Description;
        }

        public String getAuthor() {
            return this.m_Author;
        }

        public String getOrganization() {
            return this.m_Organization;
        }

        public ImageIcon getLogo() {
            return this.m_Logo;
        }

        @Override
        public int compareTo(Module o) {
            if (this.getName().startsWith(ADAMS_PREFIX) && o.getName().startsWith(ADAMS_PREFIX)) {
                return this.getName().compareTo(o.getName());
            }
            if (this.getName().startsWith(ADAMS_PREFIX) || o.getName().startsWith(ADAMS_PREFIX)) {
                if (this.getName().startsWith(ADAMS_PREFIX)) {
                    return -1;
                }
                return 1;
            }
            return this.getName().compareTo(o.getName());
        }

        public boolean equals(Object o) {
            if (o instanceof Module) {
                return this.compareTo((Module)o) == 0;
            }
            return false;
        }

        public String toString() {
            return this.m_Name;
        }
    }
}

