/*
 * Decompiled with CFR 0.152.
 */
package adams.flow;

import adams.core.Pausable;
import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.VariablesHandler;
import adams.core.io.PlaceholderFile;
import adams.core.management.ProcessUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.db.AbstractDatabaseObjectWithOptionHandling;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.gui.scripting.ScriptingEngine;
import java.lang.reflect.Method;
import java.util.Vector;

public class FlowRunner
extends AbstractDatabaseObjectWithOptionHandling
implements Stoppable,
Pausable {
    private static final long serialVersionUID = 5693250462014974198L;
    public static final String METHOD_STOPALLENGINES = "stopAllEngines";
    protected PlaceholderFile m_File;
    protected AbstractActor m_Actor;
    protected AbstractActor m_ActualActor;
    protected AbstractActor m_LastActor;
    protected boolean m_Headless;
    protected String m_Home;
    protected boolean m_CleanUp;
    protected boolean m_InterruptedByUser;

    @Override
    public String globalInfo() {
        return "Executes flows from command-line.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("home", "home", "");
        this.m_OptionManager.add("headless", "headless", false);
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
        this.m_OptionManager.add("actor", "actor", new Flow());
        this.m_OptionManager.add("clean-up", "cleanUp", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ActualActor = null;
        this.m_LastActor = null;
        this.m_dbc = null;
    }

    public void setHome(String value) {
        this.m_Home = value;
        this.reset();
    }

    public String getHome() {
        return this.m_Home;
    }

    public String homeTipText() {
        return "The directory to use as the project's home directory, overriding the automatically determined one.";
    }

    public void setHeadless(boolean value) {
        this.m_Headless = value;
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public String headlessTipText() {
        return "If set to true, the actor is run in headless mode without GUI components.";
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
        this.reset();
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to load the actor from.";
    }

    public void setActor(AbstractActor value) {
        this.m_Actor = value;
        this.reset();
    }

    public AbstractActor getActor() {
        return this.m_Actor;
    }

    public String actorTipText() {
        return "The actor to execute (if not loaded from file).";
    }

    public void setCleanUp(boolean value) {
        this.m_CleanUp = value;
    }

    public boolean isCleanUp() {
        return this.m_CleanUp;
    }

    public String cleanUpTipText() {
        return "If set to true, then a clean up is performed after execution, removing any graphical output as well.";
    }

    public AbstractActor getLastActor() {
        return this.m_LastActor;
    }

    public String execute() {
        String result = null;
        this.m_InterruptedByUser = false;
        if (this.isDebugOn()) {
            this.debug("PID: " + ProcessUtils.getVirtualMachinePID());
        }
        this.establishDatabaseConnection();
        if (this.m_LastActor != null) {
            this.m_LastActor.destroy();
        }
        if (!this.m_File.isDirectory()) {
            Vector<String> errors = new Vector<String>();
            this.m_ActualActor = ActorUtils.read(this.m_File.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Failed to load actor from '" + this.m_File + "'!\n" + Utils.flatten(errors, "\n");
                return result;
            }
            if (this.m_ActualActor instanceof VariablesHandler) {
                ActorUtils.updateVariablesWithFlowFilename((VariablesHandler)((Object)this.m_ActualActor), this.m_File);
            }
        } else {
            this.m_ActualActor = this.m_Actor.shallowCopy(true);
        }
        this.m_LastActor = this.m_ActualActor;
        if (this.getDebugLevel() > 1) {
            this.debug("Actor command-line: " + this.m_ActualActor.toCommandLine(), 2);
        }
        try {
            this.m_ActualActor.setHeadless(this.isHeadless());
            if (this.isDebugOn() && this.m_ActualActor.isHeadless()) {
                this.debug("Running in headless mode");
            }
            result = this.m_ActualActor.setUp();
            if (this.isDebugOn()) {
                this.debug("setUp() result: " + result);
            }
            if (result == null) {
                result = this.m_ActualActor.execute();
                if (this.isDebugOn()) {
                    this.debug("execute() result: " + result);
                }
                if (this.m_ActualActor.hasStopMessage()) {
                    this.debug("stop message: " + this.m_ActualActor.getStopMessage());
                    if (result == null) {
                        result = this.m_ActualActor.getStopMessage();
                    }
                }
            }
            this.m_ActualActor.wrapUp();
            if (this.isDebugOn()) {
                this.debug("wrapUp() finished");
            }
            if (this.m_CleanUp) {
                this.m_ActualActor.cleanUp();
                if (this.isDebugOn()) {
                    this.debug("cleanUp() finished");
                }
            }
            if (result != null) {
                result = !this.m_File.isDirectory() ? "Error executing flow '" + this.m_File + "': " + result : "Error executing actor: " + result;
            }
        }
        catch (Exception e) {
            result = e.toString();
            e.printStackTrace();
        }
        this.m_ActualActor = null;
        if (this.m_InterruptedByUser && result == null) {
            result = "Flow interrupted by user!";
        }
        return result;
    }

    @Override
    public void pauseExecution() {
        if (this.m_ActualActor != null && this.m_ActualActor instanceof Pausable) {
            ((Pausable)((Object)this.m_ActualActor)).pauseExecution();
        }
    }

    @Override
    public boolean isPaused() {
        if (this.m_ActualActor != null && this.m_ActualActor instanceof Pausable) {
            return ((Pausable)((Object)this.m_ActualActor)).isPaused();
        }
        return false;
    }

    @Override
    public void resumeExecution() {
        if (this.m_ActualActor != null && this.m_ActualActor instanceof Pausable) {
            ((Pausable)((Object)this.m_ActualActor)).resumeExecution();
        }
    }

    @Override
    public void stopExecution() {
        if (this.m_ActualActor != null) {
            this.m_InterruptedByUser = true;
            this.m_ActualActor.stopExecution();
        }
    }

    public static FlowRunner forName(String classname, String[] options) {
        FlowRunner result;
        try {
            result = (FlowRunner)OptionUtils.forName(FlowRunner.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static FlowRunner forCommandLine(String cmdline) {
        return (FlowRunner)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    protected static void stopAllEngines(Class[] engines) {
        for (int i = 0; i < engines.length; ++i) {
            try {
                Method method = engines[i].getMethod(METHOD_STOPALLENGINES, new Class[0]);
                method.invoke(null, new Object[0]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to call " + engines[i].getName() + "." + METHOD_STOPALLENGINES + ":");
                e.printStackTrace();
            }
        }
    }

    public static void runFlow(Class env, Class flow, Class[] engines, String[] args) {
        Environment.setEnvironmentClass(env);
        Environment.setHome(OptionUtils.getOption(args, "-home"));
        try {
            if (OptionUtils.helpRequested(args)) {
                System.out.println("Help requested...\n");
                FlowRunner flowInst = FlowRunner.forName(flow.getName(), new String[0]);
                System.out.println("\n" + OptionUtils.list(flowInst));
            } else {
                FlowRunner flowInst = FlowRunner.forName(flow.getName(), args);
                ArrayConsumer.setOptions(flowInst, args);
                String result = flowInst.execute();
                FlowRunner.stopAllEngines(engines);
                if (result == null) {
                    System.out.println("\nFinished execution!");
                } else {
                    System.err.println("\n" + result);
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FlowRunner.runFlow(Environment.class, FlowRunner.class, new Class[]{ScriptingEngine.class}, args);
    }
}

