/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.core.CloneHandler;
import adams.core.Utils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractContainer
implements Serializable,
CloneHandler<AbstractContainer> {
    private static final long serialVersionUID = -6949950627956848217L;
    protected Hashtable<String, Object> m_Values;

    protected AbstractContainer() {
        this.checkDefaultConstructor();
        this.m_Values = new Hashtable();
    }

    protected void checkDefaultConstructor() {
        try {
            this.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(this.getClass().getName() + " does not have default constructor!");
        }
    }

    @Override
    public AbstractContainer getClone() {
        return (AbstractContainer)Utils.deepCopy(this);
    }

    public abstract Enumeration<String> names();

    public Enumeration<String> stored() {
        Vector<String> result = new Vector<String>(this.m_Values.keySet());
        Collections.sort(result);
        return result.elements();
    }

    public boolean hasValue(String name) {
        return this.getValue(name) != null;
    }

    public Object getValue(String name) {
        return this.m_Values.get(name);
    }

    protected boolean isValidName(String name) {
        boolean result = false;
        Enumeration<String> names = this.names();
        while (names.hasMoreElements()) {
            if (!names.nextElement().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean store(String name, Object value) {
        if (value == null) {
            return false;
        }
        this.m_Values.put(name, value);
        return true;
    }

    public boolean setValue(String name, Object value) {
        if (this.isValidName(name)) {
            return this.store(name, value);
        }
        return false;
    }

    public abstract boolean isValid();

    public String toString() {
        String result = "";
        Enumeration<String> names = this.stored();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + name + "=" + this.getValue(name);
        }
        return result;
    }
}

