/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.CleanUpHandler;
import adams.core.ConsoleObject;
import adams.core.DebugOutputHandler;
import adams.core.Pausable;
import adams.core.Stoppable;
import adams.core.Variables;
import adams.flow.control.AbstractControlActor;

public abstract class AbstractDirector
extends ConsoleObject
implements DebugOutputHandler,
CleanUpHandler,
Stoppable,
Pausable {
    private static final long serialVersionUID = -1634725837304059804L;
    protected AbstractControlActor m_ControlActor;
    protected int m_DebugLevel;
    protected boolean m_Stopped;
    protected boolean m_Stopping;
    protected boolean m_Paused;

    public AbstractDirector() {
        this.initialize();
    }

    protected void initialize() {
    }

    public void updatePrefix() {
        if (this.m_ControlActor != null) {
            this.getSystemOut().setPrefix(this.m_ControlActor.getFullName() + "." + this.getClass().getSimpleName() + "/" + this.hashCode());
            this.getSystemErr().setPrefix(this.m_ControlActor.getFullName() + "." + this.getClass().getSimpleName() + "/" + this.hashCode());
            this.getDebugging().setPrefix(this.m_ControlActor.getFullName() + "." + this.getClass().getSimpleName() + "/" + this.hashCode());
        }
    }

    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
        this.getDebugging().setEnabled(value > 0);
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    @Override
    public void debug(String msg) {
        this.debug(msg, 1);
    }

    public void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            this.getDebugging().println(msg);
        }
    }

    public void setControlActor(AbstractControlActor value) {
        this.m_ControlActor = value;
        this.updatePrefix();
    }

    public AbstractControlActor getControlActor() {
        return this.m_ControlActor;
    }

    protected Variables getVariables() {
        return this.m_ControlActor.getVariables();
    }

    public abstract String execute();

    @Override
    public void pauseExecution() {
        this.m_Paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        while (this.isPaused() && !this.isStopped() && !this.isStopping()) {
            try {
                AbstractDirector abstractDirector = this;
                synchronized (abstractDirector) {
                    this.wait(500L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.m_Paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeExecution() {
        if (this.isPaused()) {
            this.m_Paused = false;
            try {
                AbstractDirector abstractDirector = this;
                synchronized (abstractDirector) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopExecution() {
        this.m_Stopping = true;
        if (this.isPaused()) {
            this.resumeExecution();
        }
        if (this.isDebugOn()) {
            this.debug("stop called");
        }
        for (int i = this.m_ControlActor.size() - 1; i >= 0; --i) {
            if (this.m_ControlActor.get(i).getSkip()) continue;
            this.m_ControlActor.get(i).stopExecution();
        }
        this.m_Stopped = true;
        this.m_Stopping = false;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean isStopping() {
        return this.m_Stopping;
    }

    public boolean isFinished() {
        return true;
    }

    @Override
    public void cleanUp() {
    }

    public String toString() {
        return this.getClass().getName() + "/" + this.hashCode() + ": " + (this.m_ControlActor == null ? "--" : this.m_ControlActor.getFullName());
    }
}

