/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.Tee;
import adams.flow.core.Token;
import java.util.Hashtable;

public class ConditionalTee
extends Tee {
    private static final long serialVersionUID = -5532257363818440415L;
    public static final String BACKUP_CURRENT = "current";
    protected int m_Minimum;
    protected int m_Maximum;
    protected int m_Interval;
    protected int m_Current;

    @Override
    public String globalInfo() {
        return "Counts the number of tokens that pass through and tees off the token every n-th token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "minimum", -1, -1, null);
        this.m_OptionManager.add("max", "maximum", -1, -1, null);
        this.m_OptionManager.add("interval", "interval", -1, -1, null);
    }

    public void setMinimum(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Minimum = value;
        this.reset();
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum number of tokens to count before activating (-1 to disable).";
    }

    public void setMaximum(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Maximum = value;
        this.reset();
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum number of tokens to count before de-activating (-1 to disable).";
    }

    public void setInterval(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The number of tokens (or multiples) to count before teeing-off the input token.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENT, this.m_Current);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_Current = (Integer)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Current = 0;
    }

    protected boolean canFire() {
        boolean result = true;
        if (result && this.m_Minimum > -1 && this.m_Current < this.m_Minimum) {
            result = false;
        }
        if (result && this.m_Maximum > -1 && this.m_Current > this.m_Maximum) {
            result = false;
        }
        if (result && this.m_Interval > -1 && this.m_Current % this.m_Interval != 0) {
            result = false;
        }
        if (this.isDebugOn()) {
            this.debug("current=" + this.m_Current + ", min=" + this.m_Minimum + ", max=" + this.m_Maximum + ", interval=" + this.m_Interval + ": " + result);
        }
        return result;
    }

    @Override
    public void input(Token token) {
        ++this.m_Current;
        super.input(token);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && this.canFire();
    }
}

