/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.AdditionalInformationHandler;
import adams.core.ClassLister;
import adams.core.ClassLocator;
import adams.core.CleanUpHandler;
import adams.core.DebugOutputHandler;
import adams.core.Properties;
import adams.core.QuickInfoSupporter;
import adams.core.ShallowCopySupporter;
import adams.core.SizeOf;
import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.VariablesHandler;
import adams.core.base.BaseText;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionManager;
import adams.core.option.OptionTraverser;
import adams.core.option.OptionUtils;
import adams.db.LogEntry;
import adams.db.MutableLogEntryHandler;
import adams.event.VariableChangeEvent;
import adams.event.VariableChangeListener;
import adams.flow.container.AbstractContainer;
import adams.flow.control.Flow;
import adams.flow.control.StorageHandler;
import adams.flow.core.ActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractActor
extends AbstractOptionHandler
implements Comparable,
AdditionalInformationHandler,
DebugOutputHandler,
CleanUpHandler,
Stoppable,
VariableChangeListener,
ShallowCopySupporter<AbstractActor>,
QuickInfoSupporter {
    private static final long serialVersionUID = 6658513163932343273L;
    public static final String FILE_EXTENSION = "flow";
    protected AbstractActor m_Self;
    protected String m_Name;
    protected String m_FullName;
    protected AbstractActor m_Parent;
    protected boolean m_Executed;
    protected boolean m_Stopped;
    protected String m_StopMessage;
    protected boolean m_Headless;
    protected BaseText m_Annotations;
    protected boolean m_Skip;
    protected boolean m_StopFlowOnError;
    protected HashSet<String> m_DetectedVariables;
    protected HashSet<String> m_VariablesUpdated;
    protected Hashtable<String, Object> m_BackupState;
    protected AbstractActor m_Root;
    protected Variables m_Variables;
    protected StorageHandler m_StorageHandler;

    @Override
    public String getAdditionalInformation() {
        int i;
        Class[] cls;
        StringBuilder result = new StringBuilder();
        result.append("Flow input/output:");
        boolean singleton = true;
        Vector<Class> containers = new Vector<Class>();
        if (this instanceof InputConsumer) {
            singleton = false;
            result.append("\n- input: ");
            cls = ((InputConsumer)((Object)this)).accepts();
            for (i = 0; i < cls.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(Utils.classToString(cls[i]));
                if (!ClassLocator.isSubclass(AbstractContainer.class, cls[i]) || cls[i].equals(AbstractContainer.class)) continue;
                containers.add(cls[i]);
            }
        }
        if (this instanceof OutputProducer) {
            singleton = false;
            result.append("\n- output: ");
            cls = ((OutputProducer)((Object)this)).generates();
            for (i = 0; i < cls.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(Utils.classToString(cls[i]));
                if (!ClassLocator.isSubclass(AbstractContainer.class, cls[i]) || cls[i].equals(AbstractContainer.class)) continue;
                containers.add(cls[i]);
            }
        }
        if (singleton) {
            result.append("\n-singleton-");
        }
        if (containers.size() > 0) {
            result.append("\nContainer information:");
            for (i = 0; i < containers.size(); ++i) {
                result.append("\n- " + ((Class)containers.get(i)).getName() + ": ");
                try {
                    AbstractContainer cont = (AbstractContainer)((Class)containers.get(i)).newInstance();
                    boolean first = true;
                    Enumeration<String> enm = cont.names();
                    while (enm.hasMoreElements()) {
                        if (!first) {
                            result.append(", ");
                        }
                        result.append(enm.nextElement());
                        first = false;
                    }
                    continue;
                }
                catch (Exception e) {
                    result.append("[error]");
                    this.getSystemErr().println("Failed to instantiate container '" + ((Class)containers.get(i)).getName() + "':");
                    this.getSystemErr().printStackTrace(e);
                }
            }
        }
        return result.toString();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Parent = null;
        this.m_Root = null;
        this.m_Headless = false;
        this.m_FullName = null;
        this.m_Name = "";
        this.m_DetectedVariables = null;
        this.m_VariablesUpdated = new HashSet();
        this.m_Self = this;
        this.updatePrefix();
    }

    protected void updatePrefix() {
        this.getSystemOut().setPrefix(this.getFullName() + "/" + this.hashCode());
        this.getSystemErr().setPrefix(this.getFullName() + "/" + this.hashCode());
        this.getDebugging().setPrefix(this.getFullName() + "/" + this.hashCode());
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", this.getDefaultName());
        this.m_OptionManager.add("annotation", "annotations", new BaseText(""));
        this.m_OptionManager.add("skip", "skip", false);
        this.m_OptionManager.add("stop-flow-on-error", "stopFlowOnError", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.pruneBackup();
    }

    public String getDefaultName() {
        return this.getClass().getName().replaceAll(".*\\.", "");
    }

    public void setHeadless(boolean value) {
        this.m_Headless = value;
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public void setName(String value) {
        this.m_Name = value;
        this.reset();
    }

    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The name of the actor.";
    }

    public void setAnnotations(BaseText value) {
        this.m_Annotations = value;
        this.reset();
    }

    public BaseText getAnnotations() {
        return this.m_Annotations;
    }

    public String annotationsTipText() {
        return "The annotations to attach to this actor.";
    }

    public void setSkip(boolean value) {
        this.m_Skip = value;
        this.reset();
    }

    public boolean getSkip() {
        return this.m_Skip;
    }

    public String skipTipText() {
        return "If set to true, transformation is skipped and the input token is just forwarded as it is.";
    }

    public void setStopFlowOnError(boolean value) {
        this.m_StopFlowOnError = value;
        this.reset();
    }

    public boolean getStopFlowOnError() {
        return this.m_StopFlowOnError;
    }

    public String stopFlowOnErrorTipText() {
        return "If set to true, the flow gets stopped in case this actor encounters an error; useful for critical actors.";
    }

    public void handleError(String type, String msg) {
        block12: {
            block11: {
                Flow flow = null;
                MutableLogEntryHandler handler = null;
                LogEntry entry = null;
                Properties props = null;
                if (this.getRoot() instanceof Flow) {
                    flow = (Flow)this.getRoot();
                    if (flow.getLogErrors()) {
                        entry = new LogEntry();
                    }
                } else if (this.getRoot() instanceof MutableLogEntryHandler) {
                    entry = new LogEntry();
                }
                if (entry != null) {
                    handler = (MutableLogEntryHandler)((Object)this.getRoot());
                    props = new Properties();
                    props.setProperty("Message", msg);
                    entry.setGeneration(new Date());
                    entry.setSource(this.getFullName());
                    entry.setType(type);
                    entry.setStatus("New");
                    entry.setMessage(props);
                    handler.addLogEntry(entry);
                }
                if (flow == null) break block11;
                switch (flow.getErrorHandling()) {
                    case ACTORS_ALWAYS_STOP_ON_ERROR: {
                        flow.stopExecution(msg);
                        break block12;
                    }
                    case ACTORS_DECIDE_TO_STOP_ON_ERROR: {
                        if (this.getStopFlowOnError()) {
                            flow.stopExecution(msg);
                        }
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled error handling: " + (Object)((Object)flow.getErrorHandling()));
                    }
                }
            }
            if (this.getStopFlowOnError()) {
                this.getRoot().stopExecution(msg);
            }
        }
    }

    public void setParent(AbstractActor value) {
        if (value != this.m_Parent) {
            this.m_Parent = value;
            this.m_FullName = null;
            this.m_Root = null;
            this.m_StorageHandler = null;
            this.m_Variables = null;
            this.updatePrefix();
        }
    }

    public AbstractActor getParent() {
        return this.m_Parent;
    }

    public int index() {
        int result = -1;
        if (this.m_Parent != null && this.m_Parent instanceof ActorHandler) {
            result = ((ActorHandler)((Object)this.m_Parent)).indexOf(this.getName());
        }
        return result;
    }

    public synchronized AbstractActor getRoot() {
        if (this.m_Root == null) {
            this.m_Root = this.getParent() == null ? this : this.getParent().getRoot();
        }
        return this.m_Root;
    }

    protected void updateDetectedVariables() {
        this.getOptionManager().registerVariables();
        this.m_DetectedVariables = this.findVariables();
        if (this.m_DetectedVariables.size() > 0) {
            this.getVariables().addVariableChangeListener(this);
        }
    }

    public synchronized void setVariables(Variables value) {
        if (this.m_Variables != value) {
            if (this.m_Variables != null) {
                this.getOptionManager().deregisterVariables();
                this.m_Variables.cleanUp();
            }
            this.m_Variables = value;
            this.getOptionManager().setVariables(this.m_Variables);
            this.updateDetectedVariables();
        }
    }

    public synchronized Variables getVariables() {
        if (this.m_Variables == null) {
            if (this instanceof VariablesHandler) {
                this.m_Variables = ((VariablesHandler)((Object)this)).getVariables();
            } else if (this.getParent() != null) {
                this.m_Variables = this.getParent().getVariables();
            }
        }
        return this.m_Variables;
    }

    public StorageHandler getStorageHandler() {
        if (this.m_StorageHandler == null) {
            if (this instanceof StorageHandler) {
                this.m_StorageHandler = (StorageHandler)((Object)this);
            } else if (this.getParent() != null) {
                this.m_StorageHandler = this.getParent().getStorageHandler();
            }
        }
        return this.m_StorageHandler;
    }

    public String getFullName() {
        if (this.m_FullName == null) {
            StringBuffer result = new StringBuffer(this.getName().replace(".", "\\."));
            AbstractActor parent = this.getParent();
            if (parent != null) {
                result.insert(0, parent.getFullName() + ".");
            }
            this.m_FullName = result.toString();
        }
        return this.m_FullName;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public void debug(String msg) {
        this.getDebugging().println(msg);
    }

    protected boolean canInspectOptions(Class cls) {
        return true;
    }

    protected void findVariables(OptionManager manager, final HashSet<String> variables) {
        manager.traverse(new OptionTraverser(){

            @Override
            public void handleBooleanOption(BooleanOption option) {
            }

            @Override
            public void handleClassOption(ClassOption option) {
                this.handleArgumentOption(option);
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option) {
                if (option.isVariableAttached() && !this.isSkipped(option)) {
                    variables.add(option.getVariableName());
                }
            }

            @Override
            public boolean canRecurse(Class cls) {
                return AbstractActor.this.canInspectOptions(cls);
            }

            protected boolean isSkipped(AbstractOption option) {
                if (option.getOptionHandler() instanceof AbstractActor) {
                    return ((AbstractActor)option.getOptionHandler()).getSkip();
                }
                return false;
            }
        });
    }

    public HashSet<String> findVariables() {
        return this.findVariables(this);
    }

    protected HashSet<String> findVariables(AbstractActor actor) {
        if (this.getDebugLevel() >= 5) {
            this.debug("Locating variables in " + actor.getFullName() + "...");
        }
        HashSet<String> result = new HashSet<String>();
        this.findVariables(actor.getOptionManager(), result);
        if (this.getDebugLevel() >= 5) {
            this.debug("Found variables in " + actor.getFullName() + " (" + result.size() + "): " + result);
        }
        return result;
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        if (this.m_DetectedVariables == null) {
            return;
        }
        if (this.m_VariablesUpdated.contains(e.getName())) {
            return;
        }
        if (this.m_DetectedVariables.contains(e.getName()) && e.getType() != VariableChangeEvent.Type.REMOVED) {
            this.m_VariablesUpdated.add(e.getName());
            if (this.isDebugOn()) {
                this.debug("Changes in variable '" + e.getName() + "'");
            }
        }
    }

    public HashSet<String> getDetectedVariables() {
        HashSet<String> result = this.m_DetectedVariables != null ? this.m_DetectedVariables : new HashSet();
        return result;
    }

    public String setUp() {
        this.reset();
        this.m_FullName = null;
        this.updatePrefix();
        if (this.m_OptionManager.getVariables() != this.getVariables()) {
            this.m_OptionManager.setVariables(this.getVariables());
        }
        this.m_Stopped = false;
        this.m_StopMessage = null;
        this.m_Executed = false;
        if (this.m_DetectedVariables == null) {
            this.updateDetectedVariables();
        }
        String result = this.performSetUpChecks(true);
        return result;
    }

    protected boolean isBackedUp(String key) {
        if (this.m_BackupState == null) {
            return false;
        }
        return this.m_BackupState.containsKey(key);
    }

    protected void pruneBackup(String key) {
        if (this.m_BackupState == null) {
            return;
        }
        if (!this.m_BackupState.containsKey(key)) {
            return;
        }
        this.m_BackupState.remove(key);
    }

    protected void pruneBackup() {
    }

    protected Hashtable<String, Object> backupState() {
        return new Hashtable<String, Object>();
    }

    protected void restoreState(Hashtable<String, Object> state) {
    }

    protected String updateVariables() {
        if (this.isDebugOn()) {
            this.debug("Attempting updating variables: " + this.m_VariablesUpdated);
        }
        this.m_BackupState = this.backupState();
        this.getOptionManager().updateVariableValues();
        String result = this.setUp();
        if (result == null) {
            this.restoreState(this.m_BackupState);
        }
        if (this.isDebugOn()) {
            this.debug("Finished updating variables " + this.m_VariablesUpdated + ": " + (result == null ? "successful" : result));
        }
        this.m_BackupState = null;
        this.m_VariablesUpdated.clear();
        return result;
    }

    protected boolean canPerformSetUpCheck(boolean fromSetUp, String property) {
        boolean result = true;
        String variable = this.getOptionManager().getVariableForProperty(property);
        if (fromSetUp) {
            if (variable != null) {
                result = false;
            }
        } else if (variable == null) {
            result = false;
        }
        return result;
    }

    protected String performSetUpChecks(boolean fromSetUp) {
        return null;
    }

    protected String preExecute() {
        String result = null;
        if (this.getDebugLevel() >= 10) {
            this.debug("Size before execute: " + this.sizeOf(), 10);
        }
        if (this.m_VariablesUpdated.size() > 0) {
            this.updateVariables();
            result = this.performSetUpChecks(false);
        }
        return result;
    }

    protected abstract String doExecute();

    protected String postExecute() {
        if (this.getDebugLevel() >= 10) {
            this.debug("Size after execute: " + this.sizeOf(), 10);
        }
        this.m_Executed = !this.m_Stopped;
        return null;
    }

    public String execute() {
        String result = null;
        if (!this.m_Skip) {
            if (!this.isStopped()) {
                result = this.preExecute();
            }
            if (result == null && !this.isStopped()) {
                result = this.doExecute();
            }
            if (result == null && !this.isStopped()) {
                result = this.postExecute();
            }
        }
        return result;
    }

    public boolean isFinished() {
        return true;
    }

    public void wrapUp() {
        this.getOptionManager().deregisterVariables();
        if (this.m_Variables != null) {
            this.m_Variables.removeVariableChangeListener(this);
        }
    }

    @Override
    public void cleanUp() {
        if (this.m_DetectedVariables != null) {
            this.m_DetectedVariables.clear();
            this.m_DetectedVariables = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUp();
        if (this.m_Variables != null) {
            this.m_Variables = null;
        }
        super.destroy();
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }

    public void stopExecution(String msg) {
        this.m_StopMessage = msg;
        this.stopExecution();
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean hasStopMessage() {
        return this.m_StopMessage != null;
    }

    public String getStopMessage() {
        return this.m_StopMessage;
    }

    public boolean isExecuted() {
        return this.m_Executed;
    }

    public AbstractActor getPreviousSibling() {
        int index;
        AbstractActor result = null;
        if (this.getParent() instanceof ActorHandler && (index = ((ActorHandler)((Object)this.getParent())).indexOf(this.getName())) > 0) {
            result = ((ActorHandler)((Object)this.getParent())).get(index - 1);
        }
        return result;
    }

    public AbstractActor getNextSibling() {
        int index;
        AbstractActor result = null;
        if (this.getParent() instanceof ActorHandler && (index = ((ActorHandler)((Object)this.getParent())).indexOf(this.getName())) < ((ActorHandler)((Object)this.getParent())).size() - 1) {
            result = ((ActorHandler)((Object)this.getParent())).get(index + 1);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractActor shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractActor shallowCopy(boolean expand) {
        return (AbstractActor)OptionUtils.shallowCopy(this, expand);
    }

    @Override
    public synchronized int sizeOf() {
        AbstractActor parent = this.m_Parent;
        this.m_Parent = null;
        int result = SizeOf.sizeOf(this);
        this.m_Parent = parent;
        return result;
    }

    public static String[] getFlowActors() {
        return ClassLister.getSingleton().getClassnames(AbstractActor.class);
    }

    public static AbstractActor forName(String classname, String[] options) {
        AbstractActor result;
        try {
            result = (AbstractActor)OptionUtils.forName(AbstractActor.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractActor forCommandLine(String cmdline) {
        return (AbstractActor)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

