/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ConsoleObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.EventReference;
import adams.flow.standalone.Events;
import java.util.Vector;

public class EventHelper
extends ConsoleObject {
    private static final long serialVersionUID = -763479272812116920L;

    public AbstractActor findEvent(ActorHandler group, EventReference name) {
        AbstractActor result = null;
        for (int i = 0; i < group.size(); ++i) {
            AbstractExternalActor external;
            if (group.get(i) instanceof Events) {
                Events global = (Events)group.get(i);
                int index = global.indexOf(name.toString());
                if (index <= -1) continue;
                result = global.get(index);
                break;
            }
            if (group.get(i) instanceof AbstractExternalActor && (external = (AbstractExternalActor)group.get(i)).getExternalActor() instanceof ActorHandler && (result = this.findEvent((ActorHandler)((Object)external.getExternalActor()), name)) != null) break;
        }
        return result;
    }

    public AbstractActor findEvent(AbstractActor root, EventReference name) {
        AbstractActor result = null;
        if (root == null) {
            this.getSystemErr().println("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getSystemErr().println("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findEvent((ActorHandler)((Object)root), name);
        }
        return result;
    }

    public AbstractActor findEventRecursive(AbstractActor actor, EventReference name) {
        AbstractActor result = null;
        Vector<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true);
        for (int i = 0; i < handlers.size() && (result = this.findEvent(handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }
}

