/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.LogEntryWriter;
import adams.db.LogEntry;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.dialog.TextDialog;
import adams.gui.tools.LogEntryViewerTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LogViewer
extends AbstractDisplay {
    private static final long serialVersionUID = -1980631598893105134L;
    protected BaseTableWithButtons m_TableEntries;
    protected JButton m_ButtonDisplay;
    protected JButton m_ButtonSave;
    protected TextDialog m_MessageDialog;
    protected BaseFileChooser m_BaseFileChooser;

    @Override
    public String globalInfo() {
        return "Actor that displays LogEntry objects, but doesn't store them in the database.";
    }

    @Override
    protected int getDefaultWidth() {
        return 600;
    }

    @Override
    protected int getDefaultHeight() {
        return 400;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{LogEntry.class};
    }

    @Override
    public void clearPanel() {
        ((LogEntryViewerTableModel)this.m_TableEntries.getModel()).clear();
    }

    protected void displayMessage(LogEntry entry) {
        StringBuilder content = new StringBuilder();
        Properties props = entry.getMessageAsProperties();
        Vector<String> keys = new Vector<String>(props.keySetAll());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                content.append("\n");
            }
            content.append(keys.get(i) + ":\n");
            content.append(Utils.indent(props.getProperty(keys.get(i)), 3));
        }
        if (this.m_MessageDialog == null) {
            this.m_MessageDialog = this.m_TableEntries.getParentDialog() != null ? new TextDialog(this.m_TableEntries.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new TextDialog(this.m_TableEntries.getParentFrame(), true);
        }
        this.m_MessageDialog.setTitle("Message (" + entry.getDatabaseID() + "/" + entry.getGenerationAsString() + ")");
        this.m_MessageDialog.setContent(content.toString());
        this.m_MessageDialog.setSize(400, 300);
        this.m_MessageDialog.setLocationRelativeTo(this.m_TableEntries);
        this.m_MessageDialog.setVisible(true);
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TableEntries = new BaseTableWithButtons(new LogEntryViewerTableModel());
        this.m_TableEntries.setSelectionMode(2);
        this.m_TableEntries.setAutoResizeMode(0);
        this.m_TableEntries.setInfoVisible(true);
        this.m_TableEntries.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogViewer.this.m_ButtonDisplay.setEnabled(LogViewer.this.m_TableEntries.getSelectedRowCount() == 1);
            }
        });
        result.add((Component)this.m_TableEntries, "Center");
        this.m_ButtonDisplay = new JButton("Display...");
        this.m_ButtonDisplay.setMnemonic('D');
        this.m_ButtonDisplay.setEnabled(false);
        this.m_ButtonDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = LogViewer.this.m_TableEntries.getSelectedRow();
                LogEntryViewerTableModel model = (LogEntryViewerTableModel)LogViewer.this.m_TableEntries.getModel();
                LogEntry entry = model.getLogEntryAt(row);
                LogViewer.this.displayMessage(entry);
            }
        });
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonDisplay);
        this.m_TableEntries.setDoubleClickButton(this.m_ButtonDisplay);
        this.m_ButtonSave = new JButton("Save...");
        this.m_ButtonSave.setMnemonic('S');
        this.m_ButtonSave.setEnabled(true);
        this.m_ButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = LogViewer.this.m_BaseFileChooser.showSaveDialog(LogViewer.this.m_TableEntries);
                if (retVal != 0) {
                    return;
                }
                String filename = LogViewer.this.m_BaseFileChooser.getSelectedFile().getAbsolutePath();
                LogEntryWriter.rewrite(filename);
                int[] rows = LogViewer.this.m_TableEntries.getSelectedRows();
                LogEntryViewerTableModel model = (LogEntryViewerTableModel)LogViewer.this.m_TableEntries.getModel();
                if (rows.length == 0) {
                    for (int i = 0; i < LogViewer.this.m_TableEntries.getRowCount(); ++i) {
                        LogEntryWriter.write(filename, model.getLogEntryAt(i));
                    }
                } else {
                    for (int i = 0; i < rows.length; ++i) {
                        LogEntryWriter.write(filename, model.getLogEntryAt(rows[i]));
                    }
                }
            }
        });
        this.m_TableEntries.addToButtonsPanel(this.m_ButtonSave);
        this.m_TableEntries.setOptimalColumnWidth();
        this.m_BaseFileChooser = new BaseFileChooser();
        this.m_BaseFileChooser.addChoosableFileFilter(new ExtensionFileFilter("CSV files", "csv"));
        this.m_BaseFileChooser.addChoosableFileFilter(new ExtensionFileFilter("Log files", "log"));
        this.m_BaseFileChooser.setDefaultExtension("log");
        this.m_BaseFileChooser.setAutoAppendExtension(true);
        this.m_BaseFileChooser.setCurrentDirectory(new File("."));
        this.m_BaseFileChooser.setSelectedFile(new File(this.getName() + ".log"));
        return result;
    }

    @Override
    protected void display(Token token) {
        LogEntry entry = (LogEntry)token.getPayload();
        ((LogEntryViewerTableModel)this.m_TableEntries.getModel()).add(entry, true);
        this.m_TableEntries.setOptimalColumnWidth();
    }

    @Override
    protected void cleanUpGUI() {
        if (this.m_MessageDialog != null) {
            this.m_MessageDialog.setVisible(false);
            this.m_MessageDialog = null;
        }
        super.cleanUpGUI();
    }
}

